params <-
list(demo_metadata = TRUE)

## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)
root_dir <- knitr::opts_knit$get("root.dir")
if (!is.null(root_dir)){
    # This hack fixes the relative image paths. 
    # See https://github.com/rstudio/rmarkdown/issues/2473
    knitr::opts_knit$set(
        output.dir = root_dir
    )
}
proj_root <- rprojroot::find_package_root_file() |> normalizePath() 
# Utility function for figures to force them to have the correct path
find_figure <- function(names){
    rprojroot::find_package_root_file() |>
        file.path("man", "figures", names) 
}

## ----eval=FALSE---------------------------------------------------------------
# install.packages("remotes")

## ----eval=FALSE---------------------------------------------------------------
# remotes::install_github("tidyomics/tidyprint")

## ----eval=FALSE---------------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# BiocManager::install("tidyprint")

## ----load-packages, message = FALSE, warnings = FALSE-------------------------
library(dplyr)
library(tidyr)
library(airway)
data(airway)

## ----se_raw-display-----------------------------------------------------------
airway 

## ----load-tidyprint-----------------------------------------------------------
library(tidyprint)

## ----turn-off-tidy-print, echo=FALSE, message=FALSE, warning=FALSE------------
# This makes sure that the vignette is not affected by the local tidy print setting
tidy_print_off()

## ----display-airway-----------------------------------------------------------
airway

## ----opt-in-session-----------------------------------------------------------
# Enable tidy print for current session only
tidy_print_on()
airway  

## ----opt-in-persistent, eval=FALSE--------------------------------------------
# # Enable tidy print and remember the setting
# tidy_print_on(remember = TRUE)
# airway  # Will display with tidy format in all future sessions

## ----opt-out-session, eval=FALSE----------------------------------------------
# # Disable tidy print for current session only
# tidy_print_off()
# airway  # Will display with standard format

## ----opt-out-persistent, eval=FALSE-------------------------------------------
# # Disable tidy print and remember the setting
# tidy_print_off(remember = TRUE)
# airway  # Will display with standard format in all future sessions

## ----tidy-message-example-----------------------------------------------------
tidyprint::tidy_message('message to print')

## ----demo-tidy-message--------------------------------------------------------
demo_tidy_message()

## ----session-info-------------------------------------------------------------
sessionInfo()

