/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class SimpleAlignment
extends AbstractSymbolList
implements Alignment,
Serializable {
    private Map labelToSymbolList;
    private List labels;
    private Alphabet alphabet;
    private int length;

    public SimpleAlignment(Map map) throws IllegalArgumentException {
        this.labels = Collections.unmodifiableList(new ArrayList(map.keySet()));
        this.labelToSymbolList = map;
        int n = -1;
        ArrayList<Alphabet> arrayList = new ArrayList<Alphabet>();
        Iterator iterator = this.labels.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            try {
                SymbolList symbolList = this.symbolListForLabel(e);
                arrayList.add(symbolList.getAlphabet());
                if (n == -1) {
                    n = symbolList.length();
                    continue;
                }
                if (symbolList.length() == n) continue;
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator2 = this.labels.iterator();
                while (iterator2.hasNext()) {
                    Object e2 = iterator2.next();
                    stringBuffer.append("\n\t" + e2 + " (" + this.symbolListForLabel(e2).length() + ")");
                }
                throw new IllegalArgumentException("All SymbolLists must be the same length: " + stringBuffer.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                if (this.labelToSymbolList.containsKey(e)) {
                    throw new IllegalArgumentException("The symbol list associated with " + e + " is null");
                }
                throw new BioError(noSuchElementException, "Something is screwey - map is lieing about key/values");
            }
        }
        this.alphabet = AlphabetManager.getCrossProductAlphabet(arrayList);
        this.length = n;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public List getLabels() {
        return this.labels;
    }

    public int length() {
        return this.length;
    }

    public Alignment subAlignment(Set set, Location location) throws NoSuchElementException {
        HashMap hashMap = new HashMap();
        Iterator iterator = set != null ? set.iterator() : this.getLabels().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            SymbolList symbolList = this.symbolListForLabel(e);
            if (location != null) {
                symbolList = location.symbols(symbolList);
            }
            hashMap.put(e, symbolList);
        }
        return new SimpleAlignment(hashMap);
    }

    public Symbol symbolAt(int n) {
        try {
            return this.alphabet.getSymbol(new ColAsList(n));
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "Somehow my crossproduct alphabet is incompatible with column " + n);
        }
    }

    public Symbol symbolAt(Object object, int n) {
        return this.symbolListForLabel(object).symbolAt(n);
    }

    public SymbolList symbolListForLabel(Object object) throws NoSuchElementException {
        SymbolList symbolList = (SymbolList)this.labelToSymbolList.get(object);
        if (symbolList == null) {
            throw new NoSuchElementException("No symbol list associated with label " + object);
        }
        return symbolList;
    }

    private final class ColAsList
    extends AbstractList
    implements Serializable {
        private final int col;

        protected ColAsList() {
            this.col = 0;
        }

        public ColAsList(int n) {
            this.col = n;
        }

        public Object get(int n) {
            return SimpleAlignment.this.symbolAt(SimpleAlignment.this.labels.get(n), this.col);
        }

        public int size() {
            return SimpleAlignment.this.labels.size();
        }
    }
}

