/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.util.StringTokenizer;

final class BlastLikeVersionSupport {
    public static final int UNKNOWN = 0;
    public static final int NCBI_BLASTN = 1;
    public static final int NCBI_BLASTP = 2;
    public static final int NCBI_BLASTX = 3;
    public static final int NCBI_TBLASTN = 4;
    public static final int NCBI_TBLASTX = 5;
    public static final int WU_BLASTN = 11;
    public static final int WU_BLASTP = 12;
    public static final int WU_BLASTX = 13;
    public static final int WU_TBLASTN = 14;
    public static final int WU_TBLASTX = 15;
    public static final int HMMER = 21;
    public static final int V2_0_11 = 100;
    public static final int V2_0A19MP_WASHU = 200;
    public static final int V2_0 = 300;
    public static final int STRICT = 0;
    public static final int LAZY = 1;
    private static int iMode = 0;
    private static int iProgram = 0;
    private static int iVersion = 0;
    private static String oProgramString = "unknown";
    private static String oVersionString = "unknown";
    private static String oProgramStub;

    public boolean assignProgramAndVersion(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        oProgramStub = stringTokenizer.nextToken().toLowerCase();
        oVersionString = stringTokenizer.nextToken().toLowerCase();
        if (oProgramStub.indexOf("blast") != -1) {
            oProgramString = oVersionString.indexOf("washu") == -1 ? "ncbi-".concat(oProgramStub) : "wu-".concat(oProgramStub);
        }
        if (oProgramStub.indexOf("hmmer") != -1) {
            oProgramString = oProgramStub;
        }
        if (oProgramString.equals("ncbi-blastn")) {
            iProgram = 1;
            bl = true;
        }
        if (oProgramString.equals("ncbi-blastx")) {
            iProgram = 3;
            bl = true;
        }
        if (oProgramString.equals("ncbi-blastp")) {
            iProgram = 2;
            bl = true;
        }
        if (oProgramString.equals("ncbi-tblastn")) {
            iProgram = 4;
            bl = true;
        }
        if (oProgramString.equals("ncbi-tblastx")) {
            iProgram = 5;
            bl = true;
        }
        if (oVersionString.equals("2.0.11")) {
            iVersion = 100;
        }
        if (oProgramString.equals("wu-blastn")) {
            iProgram = 11;
            bl = true;
        }
        if (oProgramString.equals("wu-blastx")) {
            iProgram = 13;
            bl = true;
        }
        if (oProgramString.equals("wu-blastp")) {
            iProgram = 12;
            bl = true;
        }
        if (oProgramString.equals("wu-tblastn")) {
            iProgram = 14;
            bl = true;
        }
        if (oProgramString.equals("wu-tblastx")) {
            iProgram = 15;
            bl = true;
        }
        if (oVersionString.equals("2.0a19mp-washu")) {
            iVersion = 200;
            bl = true;
        }
        if (oProgramString.equals("hmmer")) {
            iProgram = 21;
            bl = true;
        }
        if (oVersionString.equals("2.0")) {
            iVersion = 300;
            bl = true;
        }
        return bl;
    }

    public int getMode() {
        return iMode;
    }

    public int getProgram() {
        return iProgram;
    }

    public String getProgramString() {
        return oProgramString;
    }

    public int getVersion() {
        return iVersion;
    }

    public String getVersionString() {
        return oVersionString;
    }

    public boolean isStartOfDataSet(String string) {
        return string.startsWith("BLAST") || string.startsWith("HMMER") || string.startsWith("TBLAST");
    }

    public boolean isSupported() {
        if (iProgram == 1 || iProgram == 3 || iProgram == 2 || iProgram == 4 || iProgram == 5) {
            if (iVersion == 100) {
                return true;
            }
            if (this.getMode() == 0) {
                return false;
            }
            if (this.getMode() == 1) {
                return true;
            }
        }
        if ((iProgram == 11 || iProgram == 13 || iProgram == 12 || iProgram == 14 || iProgram == 15) && iVersion == 200) {
            return true;
        }
        if (iProgram == 21 && iVersion == 300) {
            return true;
        }
        if (this.getMode() == 0) {
            return false;
        }
        return this.getMode() == 1;
    }

    public void setMode(int n) {
        iMode = n;
    }
}

