package weka.clusterquality;

import i9.subspace.base.Cluster;

import java.util.ArrayList;

import weka.core.Instances;

public class ClusterDistribution extends ClusterQualityMeasure{
	
	private int[] clustersInSubspace = null;
	int numberOfClusters = 0;
	 
	
	@Override
	public void calculateQuality(ArrayList<Cluster> clusterList, Instances instances, ArrayList<Cluster> trueclusters) {
		
		if(clusterList.isEmpty()) {
			clustersInSubspace = null;
			numberOfClusters = 0;
			return;
		}
		
		clustersInSubspace = new int[clusterList.get(0).m_subspace.length];
		
		for(int i=0;i<clusterList.size();i++){
			Cluster cluster = clusterList.get(i);
			int clusterDim = 0;
			for (boolean b : cluster.m_subspace)
				if (b)
					clusterDim++;
			clustersInSubspace[clusterDim - 1]++;
		}
		
		numberOfClusters = clusterList.size();
	}
	
	private String toString2(int[] clustersInSubspace){
		String result = "";
		for(int i=0;i<clustersInSubspace.length;i++){
			result +=clustersInSubspace[i] + " "; 
		}
		return result;
	}
	
	public double getValue(int i){
		return numberOfClusters;
	}
	
	@Override
	public String getCustomOutput() {
		
		if(clustersInSubspace == null) {
			return "ClusterDist\t\nNumOfCluster ";
		}
		
		return "ClusterDist\t" + toString2(clustersInSubspace) + "\nNumOfCluster\t" + numberOfClusters;
	}

	@Override
	public String getName() {
		return "Cluster Distribution";
	}



}
