## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----install, eval = FALSE----------------------------------------------------
# if (!requireNamespace("BiocManager", quietly=TRUE))
#     install.packages("BiocManager")
# BiocManager::install("geyser")

## ----install github, eval = FALSE---------------------------------------------
# if (!requireNamespace("remotes", quietly=TRUE))
#      install.packages("remotes")
# remotes::install_github("davemcg/geyser")

## ----setup--------------------------------------------------------------------
library(geyser)
load(system.file('extdata/tiny_rse.Rdata', package = 'geyser'))

## ----faux_run-----------------------------------------------------------------
if (interactive()){
  geyser(tiny_rse)
}

## -----------------------------------------------------------------------------
# If needed: BiocManager::install("recount3")
if (interactive()){
  library(recount3)
  library(geyser)
  human_projects <- available_projects()
  proj_info <- subset( 
    human_projects,
    project == "SRP107937" & project_type == "data_sources" 
  )
  rse_SRP107937 <- create_rse(proj_info)
  assay(rse_SRP107937, "counts") <- transform_counts(rse_SRP107937)
  # first tweak that glues the gene name onto the gene id in the row names
  rownames(rse_SRP107937) <- paste0(rowData(rse_SRP107937)$gene_name, ' (', row.names(rse_SRP107937), ')')
  # creates two new metadata fields 
  colData(rse_SRP107937)$tissue <- colData(rse_SRP107937)$sra.sample_title %>% stringr::str_extract(.,'PRC|PR')
  colData(rse_SRP107937)$disease <- colData(rse_SRP107937)$sra.sample_title %>% stringr::str_extract(.,'AMD|Normal')
  
  geyser(rse_SRP107937, " geyser: SRP107937")
}

## ----count to se--------------------------------------------------------------
library(SummarizedExperiment)
counts <- matrix(runif(10 * 6, 1, 1e4), 10)
row.names(counts) <- paste0('gene', seq(1,10))
colnames(counts) <- LETTERS[1:6]

sample_info <- data.frame(Condition = c(rep("Unicorn", 3),
                                       rep("Horse", 3)),
                                       row.names = LETTERS[1:6])
                         
se_object <- SummarizedExperiment(assays=list(counts = counts), 
                                  colData = sample_info)

if (interactive()){
  geyser(se_object, "Magical Creatures")
}

## ----dds to se----------------------------------------------------------------
library(DESeq2)
library(airway)
data(airway)
ddsSE <- DESeqDataSet(airway, design = ~ cell + dex)

if (interactive()){
  geyser(ddsSE, "DESeq Airway Example")
}

## -----------------------------------------------------------------------------
sessionInfo()

