## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    crop = NULL, ## Related to https://stat.ethz.ch/pipermail/bioc-devel/2020-April/016656.html
    dpi = 100,
    out.width = "100%",
    message = FALSE,
    warning = FALSE,
    fig.width = 5,
    fig.height = 3
)


## ----packages-----------------------------------------------------------------
library(chevreulPlot)
library(scater)
library(scran)
library(patchwork)

data("small_example_dataset")

## -----------------------------------------------------------------------------
plot_feature_on_embedding(small_example_dataset,
    embedding = "UMAP",
    features = "Gene_0001", return_plotly = FALSE
)

## -----------------------------------------------------------------------------
plot_colData_histogram(small_example_dataset,
    group_by = "sizeFactor",
    fill_by = "Treatment"
)

## -----------------------------------------------------------------------------
plot_colData_on_embedding(small_example_dataset,
    group = "gene_snn_res.1",
    embedding = "UMAP"
)

## -----------------------------------------------------------------------------
plot_marker_features(small_example_dataset,
    group_by = "gene_snn_res.1",
    marker_method = "wilcox"
)

## ----results=FALSE, echo=FALSE, eval = FALSE----------------------------------
# plot_transcript_composition(small_example_dataset, "NRL",
#     group.by = "gene_snn_res.1", standardize = TRUE
# )

## -----------------------------------------------------------------------------
sessionInfo()

