## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(echo=TRUE)

## ----Installation, eval=FALSE-------------------------------------------------
# if (!requireNamespace("BiocManager", quietly=TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("Xenon8778/SplineDV")

## ----Importlibraries, message=FALSE-------------------------------------------
library(scRNAseq)
library(SplineDV)

## ----LoadingExampleData-------------------------------------------------------
sce <- fetchDataset('zilionis-lung-2019','2023-12-20', path="mouse")
sce

## ----MajorCellTypes-----------------------------------------------------------
table(sce$`Major cell type`,sce$`Tissue`)

## ----SplittingExperimentalConditions------------------------------------------
# Extract Healthy data
healthyCount <- sce[, sce$Tissue == "healthy"]

# Extract Tumor data
tumorCount <- sce[, sce$Tissue == "tumor"]

# Select a specific cell type - Neutrophils
healthyCount <- healthyCount[, which(healthyCount$`Major cell type` == "Neutrophils")]
print(healthyCount)

tumorCount <- tumorCount[, which(tumorCount$`Major cell type` == "Neutrophils")]
print(tumorCount)

## ----runSplineDV--------------------------------------------------------------
dvRes <- splineDV(X = tumorCount, Y = healthyCount)
head(dvRes)

## ----plotDV, out.width="75%", out.height="75%", fig.format='png'--------------
fig <- DVPlot(dvRes, targetgene='Spp1')
fig 

## ----loadHVGExampleData-------------------------------------------------------
# Healthy neutrophils data
print(healthyCount)

## ----runSplineHVG-------------------------------------------------------------
HVGRes <- splineHVG(healthyCount, nHVGs = 200)
head(HVGRes)

## ----showHVGList--------------------------------------------------------------
# Extracting HVG Gene list
HVGList <- rownames(HVGRes)[HVGRes$HVG == TRUE]
head(HVGList)

## ----plotHVG, out.width="75%", out.height="75%"-------------------------------
fig <- HVGPlot(HVGRes)
fig

## ----"citation"---------------------------------------------------------------
citation("SplineDV")

## -----------------------------------------------------------------------------
date()
sessionInfo()

