/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pdf.stream;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.jfree.pdf.dictionary.Dictionary;
import org.jfree.pdf.stream.Stream;
import org.jfree.pdf.util.Args;

public class PDFImage
extends Stream {
    int width;
    int height;
    Image image;
    String softMaskImageRef;

    public PDFImage(int number, Image img, String softMaskImageRef) {
        super(number);
        Args.nullNotPermitted(img, "img");
        this.width = img.getWidth(null);
        this.height = img.getHeight(null);
        this.image = img;
        this.softMaskImageRef = softMaskImageRef;
    }

    @Override
    public byte[] getRawStreamData() {
        BufferedImage bi;
        if (!(this.image instanceof BufferedImage)) {
            bi = new BufferedImage(this.width, this.height, 2);
            Graphics2D g2 = bi.createGraphics();
            g2.setBackground(new Color(255, 255, 255, 0));
            g2.clearRect(0, 0, this.width, this.height);
            g2.drawImage(this.image, 0, 0, null);
        } else {
            bi = (BufferedImage)this.image;
        }
        byte[] result = new byte[this.width * this.height * 3];
        int i = 0;
        for (int hh = this.height - 1; hh >= 0; --hh) {
            for (int ww = 0; ww < this.width; ++ww) {
                int rgb = bi.getRGB(ww, hh);
                result[i++] = (byte)(rgb >> 16);
                result[i++] = (byte)(rgb >> 8);
                result[i++] = (byte)rgb;
            }
        }
        return result;
    }

    @Override
    protected Dictionary createDictionary(int streamLength) {
        Dictionary dictionary = super.createDictionary(streamLength);
        dictionary.setType("/XObject");
        dictionary.put("/Subtype", "/Image");
        dictionary.put("/ColorSpace", "/DeviceRGB");
        dictionary.put("/BitsPerComponent", 8);
        dictionary.put("/Width", this.width);
        dictionary.put("/Height", this.height);
        if (this.softMaskImageRef != null) {
            dictionary.put("/SMask", this.softMaskImageRef);
        }
        return dictionary;
    }
}

