## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
suppressPackageStartupMessages(library(SummarizedExperiment))
suppressPackageStartupMessages(library(S4Vectors))
library(ClusterGVis)

# a data.frame or SummarizedExperiment object
data("exps")

head(exps)

## ----eval=TRUE,fig.width=5, message=FALSE, warning=FALSE----------------------
# check suitable cluster nmbers
getClusters(obj = exps)

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
# using kemans for clustering
ck <- clusterData(obj = exps,
                  clusterMethod = "kmeans",
                  clusterNum = 8)

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
# construct a SummarizedExperiment object
sce <- SummarizedExperiment(assays = list(counts = exps),
                            colData = S4Vectors::DataFrame(
                              sample = colnames(exps),
                              row.names = colnames(exps))
                            )

sce

# using kemans for clustering
ck2 <- clusterData(obj = sce,
                  clusterMethod = "kmeans",
                  clusterNum = 8)

## ----eval=TRUE,fig.width=10,fig.height=6, message=FALSE, warning=FALSE--------
# plot line only
visCluster(object = ck,
           plotType = "line")

## ----eval=TRUE,fig.width=5,fig.height=10, message=FALSE, warning=FALSE--------
# plot heatmap only
visCluster(object = ck,
           plotType = "heatmap")

## ----eval=TRUE,fig.width=6,fig.height=10, message=FALSE, warning=FALSE--------
# plot heatmap only
visCluster(object = ck,
           plotType = "both")

## ----eval=TRUE,fig.width=10,fig.height=9, message=FALSE, warning=FALSE--------
suppressPackageStartupMessages(library(Seurat))

data("pbmc_subset")

# find markers for every cluster compared to all remaining cells
# report only the positive ones
pbmc.markers.all <- Seurat::FindAllMarkers(pbmc_subset,
                                           only.pos = TRUE,
                                           min.pct = 0.25,
                                           logfc.threshold = 0.25)

# get top 10 genes
pbmc.markers <- pbmc.markers.all |>
  dplyr::group_by(cluster) |>
  dplyr::top_n(n = 20, wt = avg_log2FC)

# check
head(pbmc.markers)

# prepare data from seurat object
st.data <- prepareDataFromscRNA(object = pbmc_subset,
                                diffData = pbmc.markers,
                                showAverage = TRUE)

# check
str(st.data)

## ----eval=TRUE,fig.width=6,fig.height=10, message=FALSE, warning=FALSE--------
# add gene name
markGenes <- unique(pbmc.markers$gene)[
  sample(1:length(unique(pbmc.markers$gene)),40,replace = FALSE)]

# heatmap plot
# pdf('sc1.pdf',height = 10,width = 6,onefile = FALSE)
p <- visCluster(object = st.data,
           plotType = "heatmap",
           column_names_rot = 45,
           markGenes = markGenes,
           clusterOrder = c(1:9))
# dev.off()

## ----eval=TRUE,fig.width=6,fig.height=8, message=FALSE, warning=FALSE---------
library(Seurat)
data("pbmc_subset")

# transform into SingleCellExperiment 
sce <- as.SingleCellExperiment(pbmc_subset)

pbmc.markers.all <- Seurat::FindAllMarkers(pbmc_subset,
                                           only.pos = TRUE,
                                           min.pct = 0.25,
                                           logfc.threshold = 0.25)

# get top 10 genes
pbmc.markers <- pbmc.markers.all |>
  dplyr::group_by(cluster) |>
  dplyr::top_n(n = 20, wt = avg_log2FC)

st.data <- prepareDataFromscRNA(object = sce,
                                diffData = pbmc.markers[,c("cluster","gene")],
                                showAverage = TRUE)

visCluster(object = st.data,
           plotType = "heatmap",
           column_names_rot = 45,
           markGenes = markGenes,
           clusterOrder = c(1:9))

## -----------------------------------------------------------------------------
sessionInfo()

