## ----setup, include=FALSE,echo=FALSE------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    cache = TRUE,
    out.width = "100%"
)

## ----install, eval=FALSE------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("BiocMaintainerApp")

## ----load, include=TRUE,results="hide",message=FALSE,warning=FALSE------------
library(BiocMaintainerApp)

## ----exampleFilter------------------------------------------------------------

## By package name
getInfoByPackage("BiocFileCache")

## By maintainer email
tbl <- getInfoByEmail("maintainer@bioconductor.org")
head(tbl)

## By maintainer name
## Then list packages associated
tbl <- getInfoByName("Hervé Pagès")
head(tbl$package)


## ----isvalid------------------------------------------------------------------
isEmailValid("maintainer@bioconductor.org")

## ----listfunctions------------------------------------------------------------
## list invalid
## maintainers that emails cannot be delivered and any information on failure
## this is a data.frame
tbl <- listInvalid()
head(tbl)

## list needs consent
## maintainers have not consented to policies in the last year
tbl <- listNeedsConsent()	 
head(tbl)

## list bad emails
## combo: invalid and needs consent
tbl <- listAllBadEmails()
head(tbl)

## list suppression list
## emails that appear on aws suppression list and would not try to send
## this is list. 'data' element contains a data.frame of name and email
tbl <- listEmailsOnSuppressionList()
head(tbl$data)

## ----fulltable----------------------------------------------------------------

all_data <- get_maintainer_data()
tail(all_data)


## ----sessioninfo--------------------------------------------------------------
sessionInfo()

