## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    fig.height = 4,
    fig.width = 4
)

options(
  rmarkdown.html_vignette.check_title = FALSE
)

## ----setup, message = FALSE---------------------------------------------------
library(tidytof)
library(dplyr)
library(ggplot2)

count <- dplyr::count

## -----------------------------------------------------------------------------
data(phenograph_data)

phenograph_data |>
    dplyr::count(phenograph_cluster)

## -----------------------------------------------------------------------------
phenograph_data |>
    # downsample
    tof_downsample(
        group_cols = phenograph_cluster,
        method = "constant",
        num_cells = 200
    ) |>
    # count the number of downsampled cells in each cluster
    count(phenograph_cluster)

## -----------------------------------------------------------------------------
phenograph_data |>
    # downsample
    tof_downsample(
        group_cols = phenograph_cluster,
        method = "prop",
        prop_cells = 0.5
    ) |>
    # count the number of downsampled cells in each cluster
    count(phenograph_cluster)

## ----warning = FALSE, message = FALSE-----------------------------------------
rescale_max <-
    function(x, to = c(0, 1), from = range(x, na.rm = TRUE)) {
        x / from[2] * to[2]
    }

phenograph_data |>
    # preprocess all numeric columns in the dataset
    tof_preprocess(undo_noise = FALSE) |>
    # plot
    ggplot(aes(x = cd34, y = cd38)) +
    geom_hex() +
    coord_fixed(ratio = 0.4) +
    scale_x_continuous(limits = c(NA, 1.5)) +
    scale_y_continuous(limits = c(NA, 4)) +
    scale_fill_viridis_c(
        labels = function(x) round(rescale_max(x), 2)
    ) +
    labs(
        fill = "relative density"
    )

## ----warning = FALSE, message = FALSE-----------------------------------------
phenograph_data |>
    tof_preprocess(undo_noise = FALSE) |>
    tof_downsample(method = "density", density_cols = c(cd34, cd38)) |>
    # plot
    ggplot(aes(x = cd34, y = cd38)) +
    geom_hex() +
    coord_fixed(ratio = 0.4) +
    scale_x_continuous(limits = c(NA, 1.5)) +
    scale_y_continuous(limits = c(NA, 4)) +
    scale_fill_viridis_c(
        labels = function(x) round(rescale_max(x), 2)
    ) +
    labs(
        fill = "relative density"
    )

## -----------------------------------------------------------------------------
sessionInfo()

