## ----install, echo = TRUE, eval=FALSE-----------------------------------------
# if (!require("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("terapadog")

## -----------------------------------------------------------------------------
# Load the library
library(terapadog)

## ----echo =FALSE--------------------------------------------------------------
# Tutorial Example
rna_counts <- system.file("extdata", "rna_counts.tsv", package = "terapadog")
rna_data <- read.csv(rna_counts, sep = "\t")

# Check the data
head(rna_data)

## ----echo=FALSE---------------------------------------------------------------
# Tutorial Example
ribo_counts <- system.file("extdata", "ribo_counts.tsv", package = "terapadog")
ribo_data <- read.csv(ribo_counts, sep = "\t")

# Check the data
head(ribo_data)

## ----echo=FALSE---------------------------------------------------------------
# Tutorial Example
sample_info_path <- system.file("extdata", "sample_info.tsv",
                                package = "terapadog")
sample_info <- read.csv(sample_info_path, sep = "\t")

# Check the data
sample_info

## -----------------------------------------------------------------------------
# Read the paths in your R environments
path_rna_counts <- system.file("extdata", "rna_counts.tsv", 
                               package = "terapadog")
path_ribo_counts <- system.file("extdata", "ribo_counts.tsv", 
                                package = "terapadog")
sample_info_path <- system.file("extdata", "sample_info.tsv",
                                package = "terapadog")

# Call prepareTerapadogData
prep_data <- terapadog::prepareTerapadogData(path_rna_counts, path_ribo_counts,
                                  sample_info_path,"1", "2")


## -----------------------------------------------------------------------------
# Extract the matrix
expression.data <- prep_data$expression.data
print(head(expression.data))

# Extract the experimental design dataframe
exp_de <- prep_data$exp_de
print(exp_de)

## ----echo = TRUE, eval=FALSE--------------------------------------------------
# # Example of function calling
# expression.data <- id_converter(expression.data, "ensembl_gene_id")

## ----echo = TRUE, eval=FALSE--------------------------------------------------
# # Calling terapadog.
# results <- terapadog(esetm = expression.data, exp_de = exp_de)

## -----------------------------------------------------------------------------
# Load the example of terapadog results from the library
example <- system.file("extdata", "terapadog_res_example.csv", 
                                    package = "terapadog")
res_example <- read.table(example)
print(head(res_example))

## -----------------------------------------------------------------------------
# Loads apeglm
# Check and load apeglm
if (!requireNamespace("apeglm", quietly = TRUE)) {
  stop("The package 'apeglm' is required to run this vignette. Please install it using BiocManager::install('apeglm').")
}
# Execute the analysis
fc_results <- get_FCs(expression.data, exp_de)

# Print the results
print(head(fc_results))

## -----------------------------------------------------------------------------
# Execute the function
plot_FCs <- plotDTA(fc_results)

## ----session-info, echo = FALSE-----------------------------------------------
# Displays the session information
sessionInfo()

