/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.writers;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.writers.SequenceWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class StkWriter
implements SequenceWriter {
    public static final String STK_HEADER = "# STOCKHOLM 1.0";
    private PrintStream out;
    private int max_seqIDLength = 0;
    private static final int GAP_LENGTH = 10;

    public StkWriter(int seqIDLength, OutputStream o) throws IOException {
        this(seqIDLength, o, STK_HEADER);
    }

    public StkWriter(int seqIDLength, OutputStream o, String header) throws IOException {
        this.out = new PrintStream(o);
        this.max_seqIDLength = seqIDLength;
        this.out.println(header + "\n");
    }

    public StkWriter(SequenceReader reader, OutputStream o, String header) throws IOException {
        this(StkWriter.getSeqIDLength(reader), o, header);
    }

    public static int getSeqIDLength(SequenceReader reader) throws IOException {
        Sequence seq;
        int seqIDLength = 0;
        int seqLength = 0;
        while ((seq = reader.readNextSequence()) != null) {
            if (seq.getSeqName().trim().length() > seqIDLength) {
                seqIDLength = seq.getSeqName().trim().length();
            }
            if (seqLength == 0) {
                seqLength = seq.getSeqString().trim().length();
                continue;
            }
            if (seq.getSeqString().trim().length() == seqLength) continue;
            throw new IOException("Sequencec seq " + seq.getSeqName() + " is not the expected length (" + seqLength + ")");
        }
        reader.close();
        return seqIDLength;
    }

    public static int getSeqIDLength(List<Sequence> seqs) throws IOException {
        int seqIDLength = 0;
        int seqLength = 0;
        for (Sequence seq : seqs) {
            if (seq.getSeqName().trim().length() > seqIDLength) {
                seqIDLength = seq.getSeqName().trim().length();
            }
            if (seqLength == 0) {
                seqLength = seq.getSeqString().trim().length();
                continue;
            }
            if (seq.getSeqString().trim().length() == seqLength) continue;
            throw new IOException("Sequencec seq " + seq.getSeqName() + " is not the expected length (" + seqLength + ")");
        }
        return seqIDLength;
    }

    private String getSeqId(String seqid) {
        return String.format("%1$-" + (this.max_seqIDLength + 10) + "s", seqid);
    }

    @Override
    public void writeSeq(Sequence seq) throws IOException {
        this.writeSeq(seq.getSeqName(), seq.getSeqString());
    }

    public void writeSeq(String seqid, String seqString) throws IOException {
        this.out.println(this.getSeqId(seqid) + seqString);
    }

    public void writeSeq(String seqid, String desc, String seqString) throws IOException {
        throw new UnsupportedOperationException("Phylip format doesn't support sequence descriptions");
    }

    public void writeEndOfBlock() throws IOException {
        this.out.println("//");
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public static void writeSequences(SequenceReader reader, OutputStream out) throws IOException {
        StkWriter.writeSequences(reader, out, STK_HEADER);
    }

    public static void writeSequences(SequenceReader reader, OutputStream out, String header) throws IOException {
        Sequence seq;
        ArrayList<Sequence> seqList = new ArrayList<Sequence>();
        while ((seq = reader.readNextSequence()) != null) {
            seqList.add(seq);
        }
        reader.close();
        StkWriter writer = new StkWriter(StkWriter.getSeqIDLength(seqList), out, header);
        for (Sequence aseq : seqList) {
            writer.writeSeq(aseq);
        }
        writer.writeEndOfBlock();
        writer.close();
    }

    public static void main(String[] args) throws Exception {
        Sequence seq;
        Options options = new Options();
        options.addOption("r", "removeref", false, "is set, do not write the GC reference sequences to output");
        options.addOption("h", "header", true, "the header of the output file in case a differenet stk version, default is # STOCKHOLM 1.0");
        String header = STK_HEADER;
        boolean removeRef = false;
        try {
            CommandLine line = new PosixParser().parse(options, args);
            if (line.hasOption("removeref")) {
                removeRef = true;
            }
            if (line.hasOption("header")) {
                header = line.getOptionValue("header");
            }
            if ((args = line.getArgs()).length < 2) {
                throw new Exception("Need input and output files");
            }
        }
        catch (Exception e) {
            new HelpFormatter().printHelp("USAGE: to-stk <input-file> <out-file>", options);
            System.err.println("ERROR: " + e.getMessage());
            System.exit(1);
            return;
        }
        SequenceReader reader = new SequenceReader(new File(args[0]));
        PrintStream out = new PrintStream(new File(args[1]));
        StkWriter writer = new StkWriter(reader, (OutputStream)out, header);
        reader = new SequenceReader(new File(args[0]));
        while ((seq = reader.readNextSequence()) != null) {
            if (seq.getSeqName().startsWith("#") && removeRef) continue;
            writer.writeSeq(seq);
        }
        writer.writeEndOfBlock();
        writer.close();
        reader.close();
    }
}

