/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils.orientation;

import edu.msu.cme.rdp.readseq.utils.ProteinUtils;
import java.util.HashSet;

public class ProteinWordGenerator {
    public static final int WORDSIZE = 4;
    private int wordSize = 4;
    private ProteinUtils protUtils = ProteinUtils.getInstance();

    public ProteinWordGenerator(int wordSize) {
        if (wordSize < 3 || wordSize > 6) {
            // empty if block
        }
        this.wordSize = wordSize;
    }

    public HashSet<String> parseProtein(String seq) {
        HashSet<String> wordSet = new HashSet<String>();
        for (int i = 0; i <= seq.length() - this.wordSize; ++i) {
            wordSet.add(seq.substring(i, i + this.wordSize).toLowerCase());
        }
        return wordSet;
    }

    public HashSet<String> parseNuclAllFrames(String nucl) {
        return this.parseNuclAllFrames(nucl, 11);
    }

    public HashSet<String> parseNuclAllFrames(String nucl, int translTable) {
        HashSet<String> wordSet = new HashSet<String>();
        for (int i = 0; i < 3; ++i) {
            String s = this.protUtils.translateToProtein(nucl.substring(i), true, translTable);
            HashSet<String> tempSet = this.parseProtein(s);
            wordSet.addAll(tempSet);
        }
        return wordSet;
    }

    public HashSet<String> parseNuclOneFrame(String nucl) {
        return this.parseNuclOneFrame(nucl, 11);
    }

    public HashSet<String> parseNuclOneFrame(String nucl, int translTable) {
        return this.parseProtein(this.protUtils.translateToProtein(nucl, true, translTable));
    }

    public static void main(String[] args) {
        ProteinWordGenerator theObj = new ProteinWordGenerator(4);
        String nucl = "ttgaaacagattgcattttacggaaaaggagggattggaaagtcaactac";
        HashSet<String> wordSet = theObj.parseNuclAllFrames(nucl);
        for (String w : wordSet) {
            System.out.println(w);
        }
    }
}

