/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils;

public class SequenceStats {
    private int start = -1;
    private int end = -1;
    private int modelPositions;
    private int length;

    public SequenceStats(String seqString) {
        int modelPosition = 0;
        this.length = 0;
        char[] bases = seqString.toCharArray();
        for (int index = 0; index < bases.length; ++index) {
            char base = bases[index];
            if (Character.isUpperCase(base) || base == '-') {
                if (base != '-') {
                    ++this.modelPositions;
                }
                ++modelPosition;
            }
            if (!Character.isUpperCase(base)) continue;
            if (this.start == -1) {
                this.start = modelPosition;
                this.end = modelPosition;
                continue;
            }
            this.end = modelPosition;
        }
        if (this.start != -1) {
            this.length = this.end - this.start;
        }
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.length;
    }

    public int getModelPositions() {
        return this.modelPositions;
    }

    public int getStart() {
        return this.start;
    }
}

