/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq;

import edu.msu.cme.rdp.readseq.readers.IndexedSeqReader;
import edu.msu.cme.rdp.readseq.readers.SeqReader;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.writers.FastaWriter;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class ToFasta {
    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addOption("m", "mask", true, "Mask sequence name indicating columns to drop");
        String maskSeqid = null;
        try {
            CommandLine line = new PosixParser().parse(options, args);
            if (line.hasOption("mask")) {
                maskSeqid = line.getOptionValue("mask");
            }
            if ((args = line.getArgs()).length == 0) {
                throw new Exception("");
            }
        }
        catch (Exception e) {
            new HelpFormatter().printHelp("USAGE: to-fasta <input-file>", options);
            System.err.println("ERROR: " + e.getMessage());
            System.exit(1);
            return;
        }
        SeqReader reader = null;
        FastaWriter out = new FastaWriter(System.out);
        int totalSeqs = 0;
        long totalTime = System.currentTimeMillis();
        for (String fname : args) {
            Object seq;
            if (fname.equals("-")) {
                reader = new SequenceReader(System.in);
            } else {
                File seqFile = new File(fname);
                reader = maskSeqid == null ? new SequenceReader(seqFile) : new IndexedSeqReader(seqFile, maskSeqid);
            }
            long startTime = System.currentTimeMillis();
            int thisFileTotalSeqs = 0;
            while ((seq = reader.readNextSequence()) != null) {
                out.writeSeq(((Sequence)seq).getSeqName().replace(" ", "_"), ((Sequence)seq).getDesc(), ((Sequence)seq).getSeqString());
                ++thisFileTotalSeqs;
            }
            System.err.println("Converted " + thisFileTotalSeqs + " (total sequences: " + (totalSeqs += thisFileTotalSeqs) + ") sequences from " + fname + " (" + (Object)((Object)reader.getFormat()) + ") to fasta in " + (System.currentTimeMillis() - startTime) / 1000L + " s");
        }
        System.err.println("Converted " + totalSeqs + " to fasta in " + (System.currentTimeMillis() - totalTime) / 1000L + " s");
        out.close();
    }
}

