/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.multicompare;

import edu.msu.cme.rdp.multicompare.MCSample;
import edu.msu.cme.rdp.multicompare.taxon.MCTaxon;
import edu.msu.cme.rdp.taxatree.ConcretRoot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiClassifierResult {
    private ConcretRoot<MCTaxon> root;
    private List<MCSample> samples = new ArrayList<MCSample>();
    private List<String> badSequences;
    private Map<String, Long> seqCountMap;
    private HashMap<String, MCSample> sampleMap = new HashMap();

    public MultiClassifierResult(ConcretRoot root) {
        this.root = root;
    }

    public MultiClassifierResult(ConcretRoot root, List<MCSample> samples, List<String> badSequences, Map<String, Long> seqCountMap) {
        this.root = root;
        this.samples = samples;
        this.badSequences = badSequences;
        this.seqCountMap = seqCountMap;
    }

    public ConcretRoot getRoot() {
        return this.root;
    }

    public List<MCSample> getSamples() {
        return this.samples;
    }

    public List<String> getBadSequences() {
        return this.badSequences;
    }

    public Map<String, Long> getSeqCountMap() {
        return this.seqCountMap;
    }

    public MCSample getSample(String sampleName) {
        return this.sampleMap.get(sampleName);
    }

    public void addSample(MCSample sample) {
        if (!this.sampleMap.containsKey(sample.getSampleName())) {
            this.sampleMap.put(sample.getSampleName(), sample);
            this.samples.add(sample);
        }
    }

    public void addSampleList(List<MCSample> samples) {
        for (MCSample sample : samples) {
            this.addSample(sample);
        }
    }
}

