/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier;

import edu.msu.cme.rdp.classifier.ClassificationResult;
import edu.msu.cme.rdp.classifier.GenusWordConditionalProb;
import edu.msu.cme.rdp.classifier.HierarchyTree;
import edu.msu.cme.rdp.classifier.RankAssignment;
import edu.msu.cme.rdp.classifier.ShortSequenceException;
import edu.msu.cme.rdp.classifier.TrainingInfo;
import edu.msu.cme.rdp.classifier.utils.ClassifierSequence;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.utils.orientation.GoodWordIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class Classifier {
    private TrainingInfo trainingInfo;
    private final int NUM_OF_RUNS = 100;
    private final int MAX_NUM_OF_WORDS = 5000;
    public static final int MIN_SEQ_LEN = 50;
    public static final int MAX_SEQ_LEN = 5000;
    public static final int MIN_GOOD_WORDS = 42;
    public static final int MIN_BOOTSTRSP_WORDS = 5;
    private float[][] querySeq_wordProbArr;
    private float[] accumulateProbArr;
    private long seed = 1L;
    private Random randomGenerator = new Random(this.seed);
    private Random randomSelectGenera = new Random();

    Classifier(TrainingInfo t) {
        this.trainingInfo = t;
        int nodeListSize = this.trainingInfo.getGenusNodeListSize();
        this.querySeq_wordProbArr = new float[5000][nodeListSize];
        this.accumulateProbArr = new float[nodeListSize];
    }

    public String getTrainRank() {
        return this.trainingInfo.getTrainRank();
    }

    public ClassificationResult classify(Sequence seq) throws IOException {
        return this.classify(new ClassifierSequence(seq));
    }

    public ClassificationResult classify(ClassifierSequence seq) {
        return this.classify(seq, 5);
    }

    public ClassificationResult classify(ClassifierSequence seq, int min_bootstrap_words) {
        GenusWordConditionalProb gProb = null;
        int nodeListSize = this.trainingInfo.getGenusNodeListSize();
        boolean reversed = false;
        try {
            int[] wordIndexArr = seq.getWordIndexArr();
            if (this.trainingInfo.isSeqReversed(wordIndexArr, seq.getGoodWordCount())) {
                seq = seq.getReversedSeq();
                wordIndexArr = seq.getWordIndexArr();
                reversed = true;
            }
            int goodWordCount = seq.getGoodWordCount();
            if (seq.getSeqString().length() < 50) {
                throw new ShortSequenceException(seq.getSeqName(), "ShortSequenceException: The length of sequence with recordID=" + seq.getSeqName() + " is less than " + 50);
            }
            if (goodWordCount < 42) {
                throw new ShortSequenceException(seq.getSeqName(), "ShortSequenceException: The sequence with recordID=" + seq.getSeqName() + " does not have enough valid words, minimum " + 42 + " are required");
            }
            if (goodWordCount > 5000) {
                this.querySeq_wordProbArr = new float[goodWordCount][nodeListSize];
            }
            int NUM_OF_SELECTIONS = Math.max(goodWordCount / GoodWordIterator.getWordsize(), min_bootstrap_words);
            for (int offset = 0; offset < goodWordCount; ++offset) {
                int wordIndex = wordIndexArr[offset];
                float wordPrior = this.trainingInfo.getLogWordPrior(wordIndex);
                for (int node = 0; node < nodeListSize; ++node) {
                    this.querySeq_wordProbArr[offset][node] = wordPrior - this.trainingInfo.getLogLeaveCount(node);
                }
                int start = this.trainingInfo.getStartIndex(wordIndex);
                int stop = this.trainingInfo.getStopIndex(wordIndex);
                for (int n = start; n < stop; ++n) {
                    gProb = this.trainingInfo.getWordConditionalProbObject(n);
                    this.querySeq_wordProbArr[offset][gProb.getGenusIndex()] = gProb.getProbability();
                }
            }
            for (int j = 0; j < goodWordCount; ++j) {
                for (int node = 0; node < nodeListSize; ++node) {
                    int n = node;
                    this.accumulateProbArr[n] = this.accumulateProbArr[n] + this.querySeq_wordProbArr[j][node];
                }
            }
            float maxPosteriorProb = Float.NEGATIVE_INFINITY;
            int determinedNodeIndex = 0;
            for (int node = 0; node < nodeListSize; ++node) {
                if (this.accumulateProbArr[node] > maxPosteriorProb) {
                    determinedNodeIndex = node;
                    maxPosteriorProb = this.accumulateProbArr[node];
                }
                this.accumulateProbArr[node] = 0.0f;
            }
            HashMap<HierarchyTree, RankAssignment> determinedMap = new HashMap<HierarchyTree, RankAssignment>();
            for (HierarchyTree aNode = this.trainingInfo.getGenusNodebyIndex(determinedNodeIndex); aNode != null; aNode = aNode.getParent()) {
                determinedMap.put(aNode, new RankAssignment(aNode, 0.0f));
            }
            this.randomGenerator.setSeed(this.seed);
            boolean tied = false;
            for (int i = 0; i < 100; ++i) {
                int node;
                int node2;
                for (int j = 0; j < NUM_OF_SELECTIONS; ++j) {
                    int randomIndex = this.randomGenerator.nextInt(goodWordCount);
                    for (node2 = 0; node2 < nodeListSize; ++node2) {
                        int n = node2;
                        this.accumulateProbArr[n] = this.accumulateProbArr[n] + this.querySeq_wordProbArr[randomIndex][node2];
                    }
                }
                maxPosteriorProb = Float.NEGATIVE_INFINITY;
                int bestNodeIndex = 0;
                for (node = 0; node < nodeListSize; ++node) {
                    if (!(this.accumulateProbArr[node] >= maxPosteriorProb)) continue;
                    if (this.accumulateProbArr[node] > maxPosteriorProb) {
                        bestNodeIndex = node;
                        maxPosteriorProb = this.accumulateProbArr[node];
                        tied = false;
                        continue;
                    }
                    tied = true;
                }
                if (tied) {
                    ArrayList<Integer> possibleSet = new ArrayList<Integer>();
                    for (node2 = 0; node2 < nodeListSize; ++node2) {
                        if (this.accumulateProbArr[node2] != maxPosteriorProb) continue;
                        possibleSet.add(node2);
                    }
                    bestNodeIndex = (Integer)possibleSet.get(this.randomSelectGenera.nextInt(possibleSet.size()));
                }
                for (node = 0; node < nodeListSize; ++node) {
                    this.accumulateProbArr[node] = 0.0f;
                }
                this.addConfidence(this.trainingInfo.getGenusNodebyIndex(bestNodeIndex), determinedMap);
            }
            List finalAssigns = this.getFinalResultList(determinedMap, this.trainingInfo.getGenusNodebyIndex(determinedNodeIndex));
            ClassificationResult finalResult = new ClassificationResult(seq, reversed, finalAssigns, this.trainingInfo.getHierarchyInfo());
            return finalResult;
        }
        catch (IOException ex) {
            throw new ShortSequenceException(seq.getSeqName(), "ShortSequenceException: The length of sequence with recordID=" + seq.getSeqName() + " is less than " + 50);
        }
    }

    public void addConfidence(HierarchyTree node, HashMap map) {
        while (node != null) {
            RankAssignment assign = (RankAssignment)map.get(node);
            if (assign != null) {
                assign.setConfidence(assign.getConfidence() + 1.0f);
            }
            node = node.getParent();
        }
    }

    private List getFinalResultList(HashMap map, HierarchyTree aNode) {
        ArrayList<RankAssignment> finalAssigns = new ArrayList<RankAssignment>();
        while (aNode != null) {
            RankAssignment assign = (RankAssignment)map.get(aNode);
            assign.setConfidence(assign.getConfidence() / 100.0f);
            finalAssigns.add(0, assign);
            aNode = aNode.getParent();
        }
        return finalAssigns;
    }

    private void addBestGenusNode(HierarchyTree node, List resultList) {
        RankAssignment result;
        int node_taxid = node.getTaxid();
        Iterator it = resultList.iterator();
        boolean found = false;
        while (it.hasNext()) {
            result = (RankAssignment)it.next();
            if (node_taxid != result.getBestClass().getTaxid()) continue;
            result.setConfidence(result.getConfidence() + 1.0f);
            found = true;
            break;
        }
        if (!found) {
            result = new RankAssignment(node, 1.0f);
            resultList.add(result);
        }
    }

    private void findAncestor(HierarchyTree root, RankAssignment curNode, List ancestorList) {
        if (curNode == null) {
            return;
        }
        if (curNode.getBestClass().getTaxid() == root.getTaxid()) {
            ancestorList.add(curNode);
            return;
        }
        RankAssignment parent = new RankAssignment(curNode.getBestClass().getParent(), curNode.getConfidence());
        this.findAncestor(root, parent, ancestorList);
        ancestorList.add(curNode);
    }

    private List getGreedyPath(HierarchyTree root, List resultList) {
        ArrayList votingList = new ArrayList();
        for (RankAssignment aResult : resultList) {
            ArrayList ancestorList = new ArrayList();
            this.findAncestor(root, aResult, ancestorList);
            votingList.add(ancestorList);
        }
        if (votingList.size() == 0) {
            return null;
        }
        int ancestorIndex = 0;
        ArrayList greedyList = new ArrayList();
        greedyList.add(((List)votingList.get(0)).get(ancestorIndex));
        ((RankAssignment)((List)votingList.get(0)).get(ancestorIndex)).setConfidence(1.0f);
        while (root.getSizeofSubclasses() > 0) {
            ++ancestorIndex;
            RankAssignment bestNode = null;
            ArrayList<RankAssignment> tempList = new ArrayList<RankAssignment>();
            for (int i = 0; i < votingList.size(); ++i) {
                boolean found = false;
                Iterator tmpIt = tempList.iterator();
                RankAssignment aResult = null;
                if (((List)votingList.get(i)).size() <= ancestorIndex) continue;
                aResult = (RankAssignment)((List)votingList.get(i)).get(ancestorIndex);
                while (tmpIt.hasNext()) {
                    RankAssignment tmp = (RankAssignment)tmpIt.next();
                    if (aResult.getBestClass().getTaxid() != tmp.getBestClass().getTaxid()) continue;
                    tmp.setConfidence(tmp.getConfidence() + aResult.getConfidence());
                    if (tmp.getBestClass().getParent().getTaxid() == root.getTaxid() && tmp.getConfidence() > bestNode.getConfidence()) {
                        bestNode = tmp;
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                tempList.add(aResult);
                if (aResult.getBestClass().getParent().getTaxid() != root.getTaxid()) continue;
                if (bestNode == null) {
                    bestNode = aResult;
                    continue;
                }
                if (!(aResult.getConfidence() > bestNode.getConfidence())) continue;
                bestNode = aResult;
            }
            bestNode.setConfidence(bestNode.getConfidence() / 100.0f);
            greedyList.add(bestNode);
            root = bestNode.getBestClass();
        }
        return greedyList;
    }
}

