/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bridge.Biocorba.Seqcore;

import java.util.Iterator;
import java.util.List;
import org.Biocorba.Seqcore.AnonymousSeq;
import org.Biocorba.Seqcore.RequestTooLarge;
import org.Biocorba.Seqcore.SeqType;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SymbolListAdapter
implements SymbolList {
    private AnonymousSeq anonymousSeq;
    private SymbolList symList;

    public SymbolListAdapter(AnonymousSeq anonymousSeq) throws IllegalAlphabetException, IllegalSymbolException, BioException {
        Alphabet alphabet = null;
        SeqType seqType = anonymousSeq.type();
        if (seqType == SeqType.DNA) {
            alphabet = DNATools.getDNA();
        } else if (seqType == SeqType.RNA) {
            alphabet = AlphabetManager.alphabetForName("RNA");
        } else if (seqType == SeqType.PROTEIN) {
            alphabet = ProteinTools.getAlphabet();
        } else {
            throw new IllegalAlphabetException("Could not find alphabet for " + seqType);
        }
        SymbolParser symbolParser = alphabet.getParser("token");
        try {
            this.symList = symbolParser.parse(anonymousSeq.get_seq());
        }
        catch (RequestTooLarge requestTooLarge) {
            throw new BioException((Throwable)((Object)requestTooLarge), "Unable to grap sequence string from CORBA object");
        }
        this.anonymousSeq = anonymousSeq;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void edit(Edit edit) throws ChangeVetoException {
        throw new ChangeVetoException("Can't modify SymbolList");
    }

    public Alphabet getAlphabet() {
        return this.symList.getAlphabet();
    }

    public AnonymousSeq getAnonymousSeq() {
        return this.anonymousSeq;
    }

    public Iterator iterator() {
        return this.symList.iterator();
    }

    public int length() {
        return this.symList.length();
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public String seqString() {
        return this.symList.seqString();
    }

    public SymbolList subList(int n, int n2) throws IndexOutOfBoundsException {
        return this.symList.subList(n, n2);
    }

    public String subStr(int n, int n2) throws IndexOutOfBoundsException {
        return this.symList.subStr(n, n2);
    }

    public Symbol symbolAt(int n) throws IndexOutOfBoundsException {
        return this.symList.symbolAt(n);
    }

    public List toList() {
        return this.symList.toList();
    }
}

