/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ModelTrainer;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class WMAsMM
implements MarkovModel,
Serializable {
    private static final int[] advance = new int[]{1};
    private final WeightMatrix wm;
    private final FiniteAlphabet stateAlpha;
    private final MagicalState magicalState;
    private final EmissionState[] states;
    private final Map transFrom;
    private final Map transTo;
    private final Map transWeights;
    private final transient ChangeSupport changeSupport;
    private final transient MarkovModel.DistributionForwarder distForwarder;

    public WMAsMM(WeightMatrix weightMatrix) throws IllegalSymbolException {
        try {
            this.changeSupport = new ChangeSupport();
            this.distForwarder = new MarkovModel.DistributionForwarder(this, this.changeSupport);
            this.transFrom = new HashMap();
            this.transTo = new HashMap();
            this.transWeights = new HashMap();
            this.wm = weightMatrix;
            this.magicalState = MagicalState.getMagicalState(weightMatrix.getAlphabet(), 1);
            SimpleAlphabet simpleAlphabet = new SimpleAlphabet();
            simpleAlphabet.addSymbol(this.magicalState);
            this.stateAlpha = simpleAlphabet;
            this.states = new EmissionState[weightMatrix.columns()];
            int n = 0;
            while (n <= weightMatrix.columns()) {
                if (n < weightMatrix.columns()) {
                    this.states[n] = new SimpleEmissionState(String.valueOf(n), Annotation.EMPTY_ANNOTATION, advance, weightMatrix.getColumn(n));
                    simpleAlphabet.addSymbol(this.states[n]);
                    weightMatrix.getColumn(n).addChangeListener(this.distForwarder);
                }
                MagicalState magicalState = n == 0 ? this.magicalState : this.states[n - 1];
                MagicalState magicalState2 = n == weightMatrix.columns() ? this.magicalState : this.states[n];
                FiniteAlphabet finiteAlphabet = (FiniteAlphabet)magicalState.getMatches();
                this.transFrom.put(magicalState, magicalState2.getMatches());
                this.transTo.put(magicalState2, finiteAlphabet);
                UniformDistribution uniformDistribution = new UniformDistribution(finiteAlphabet);
                this.transWeights.put(magicalState, finiteAlphabet);
                ++n;
            }
            simpleAlphabet.setName("Weight Matrix columns");
        }
        catch (ChangeVetoException changeVetoException) {
            throw new BioError(changeVetoException, "Assertion Failure: Should be able to manipulate my state alphabet.");
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "Assertion Failure: Should be able to manipulate my state alphabet.");
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.changeSupport.addChangeListener(changeListener, changeType);
    }

    public void addState(State state) throws IllegalSymbolException, ChangeVetoException {
        if (this.stateAlphabet().contains(state)) {
            throw new IllegalSymbolException(state, "Can't add a state to a model that already contains it");
        }
        throw new ChangeVetoException("addState not supported by " + this.getClass());
    }

    public boolean containsTransition(State state, State state2) throws IllegalSymbolException {
        FiniteAlphabet finiteAlphabet = this.stateAlphabet();
        finiteAlphabet.validate(state);
        finiteAlphabet.validate(state2);
        return this.transitionsFrom(state).contains(state2);
    }

    public void createTransition(State state, State state2) throws ChangeVetoException {
        throw new ChangeVetoException("destroyTransition not supported by " + this.getClass());
    }

    public void destroyTransition(State state, State state2) throws ChangeVetoException {
        throw new ChangeVetoException("destroyTransition not supported by " + this.getClass());
    }

    public Alphabet emissionAlphabet() {
        return this.wm.getAlphabet();
    }

    public Distribution getWeights(State state) throws IllegalSymbolException {
        this.stateAlpha.validate(state);
        return (Distribution)this.transWeights.get(state);
    }

    public int heads() {
        return 1;
    }

    protected int index(State state) {
        int n = 0;
        while (n < this.states.length) {
            if (state == this.states[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public MagicalState magicalState() {
        return this.magicalState;
    }

    public void registerWithTrainer(ModelTrainer modelTrainer) throws BioException {
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.changeSupport.removeChangeListener(changeListener, changeType);
    }

    public void removeState(State state) throws IllegalSymbolException, ChangeVetoException {
        this.stateAlphabet().validate(state);
        throw new ChangeVetoException("removeState not supported by " + this.getClass());
    }

    public void setWeights(State state, Distribution distribution) throws ChangeVetoException {
        throw new ChangeVetoException("Can't replace distribution in immutable model");
    }

    public FiniteAlphabet stateAlphabet() {
        return this.stateAlpha;
    }

    public FiniteAlphabet transitionsFrom(State state) throws IllegalSymbolException {
        FiniteAlphabet finiteAlphabet = this.stateAlphabet();
        finiteAlphabet.validate(state);
        return (FiniteAlphabet)this.transFrom.get(state);
    }

    public FiniteAlphabet transitionsTo(State state) throws IllegalSymbolException {
        FiniteAlphabet finiteAlphabet = this.stateAlphabet();
        finiteAlphabet.validate(state);
        return (FiniteAlphabet)this.transTo.get(state);
    }
}

