/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.dist.IgnoreCountsTrainer;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleReversibleTranslationTable;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ListWrapper;

public class TranslatedDistribution
implements Distribution,
Serializable {
    private static Map cache = new HashMap();
    private static ListWrapper gopher = new ListWrapper();
    private final Distribution other;
    private final ReversibleTranslationTable table;
    protected transient ChangeSupport changeSupport = null;
    private transient ChangeListener forwarder = new Forwarder();

    private TranslatedDistribution(ReversibleTranslationTable reversibleTranslationTable, Distribution distribution) throws IllegalAlphabetException {
        if (reversibleTranslationTable.getTargetAlphabet() != distribution.getAlphabet()) {
            throw new IllegalAlphabetException("Table target alphabet and distribution alphabet don't match: " + reversibleTranslationTable.getTargetAlphabet().getName() + " and " + distribution.getAlphabet().getName());
        }
        this.other = distribution;
        this.table = reversibleTranslationTable;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener);
        }
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener, changeType);
        }
    }

    public Alphabet getAlphabet() {
        return this.table.getSourceAlphabet();
    }

    public static TranslatedDistribution getDistribution(FiniteAlphabet finiteAlphabet, Distribution distribution) throws IllegalAlphabetException {
        Alphabet alphabet = distribution.getAlphabet();
        if (!(alphabet instanceof FiniteAlphabet)) {
            throw new IllegalAlphabetException("Source distribution must have a finite alphabet: " + alphabet.getName());
        }
        return TranslatedDistribution.getDistribution(new SimpleReversibleTranslationTable(finiteAlphabet, (FiniteAlphabet)alphabet), distribution);
    }

    public static TranslatedDistribution getDistribution(ReversibleTranslationTable reversibleTranslationTable, Distribution distribution) {
        Map map = cache;
        synchronized (map) {
            TranslatedDistribution translatedDistribution;
            List<Object> list = Arrays.asList(reversibleTranslationTable, distribution);
            gopher.setList(list);
            SoftReference softReference = (SoftReference)cache.get(list);
            try {
                if (softReference == null) {
                    translatedDistribution = new TranslatedDistribution(reversibleTranslationTable, distribution);
                    cache.put(new ListWrapper(list), new SoftReference<TranslatedDistribution>(translatedDistribution));
                } else {
                    translatedDistribution = (TranslatedDistribution)softReference.get();
                    if (translatedDistribution == null) {
                        translatedDistribution = new TranslatedDistribution(reversibleTranslationTable, distribution);
                        cache.put(new ListWrapper(list), new SoftReference<TranslatedDistribution>(translatedDistribution));
                    }
                }
            }
            catch (IllegalAlphabetException illegalAlphabetException) {
                throw new BioError(illegalAlphabetException, "The parent's null distribution is not complementable, but the parent is. Something is wrong with the parent");
            }
            TranslatedDistribution translatedDistribution2 = translatedDistribution;
            Object var4_8 = null;
            return translatedDistribution2;
        }
    }

    public Distribution getNullModel() {
        return TranslatedDistribution.getDistribution(this.table, this.other.getNullModel());
    }

    public ReversibleTranslationTable getTable() {
        return this.table;
    }

    public double getWeight(Symbol symbol) throws IllegalSymbolException {
        return this.other.getWeight(this.table.translate(symbol));
    }

    public void registerWithTrainer(DistributionTrainerContext distributionTrainerContext) {
        distributionTrainerContext.registerDistribution(this.other);
        distributionTrainerContext.registerTrainer(this, new IgnoreCountsTrainer(){

            public void addCount(DistributionTrainerContext distributionTrainerContext, AtomicSymbol atomicSymbol, double d) throws IllegalSymbolException {
                distributionTrainerContext.addCount(TranslatedDistribution.this.other, TranslatedDistribution.this.table.translate(atomicSymbol), d);
            }
        });
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(changeListener);
            }
        }
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(changeListener, changeType);
            }
        }
    }

    public Symbol sampleSymbol() {
        try {
            return this.table.untranslate(this.other.sampleSymbol());
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "Somehow, I have been unable to untranslate a symbol");
        }
    }

    public void setNullModel(Distribution distribution) throws IllegalAlphabetException, ChangeVetoException {
        throw new ChangeVetoException("TranslatedDistribution objects can't have their null models changed.");
    }

    public void setWeight(Symbol symbol, double d) throws IllegalSymbolException, ChangeVetoException {
        this.other.setWeight(this.table.translate(symbol), d);
    }

    private class Forwarder
    implements ChangeListener {
        Forwarder() {
        }

        private ChangeEvent generateChangeEvent(ChangeEvent changeEvent) {
            ChangeType changeType = changeEvent.getType();
            Object[] objectArray = changeEvent.getChange();
            Object[] objectArray2 = changeEvent.getPrevious();
            if (changeType == Distribution.WEIGHTS) {
                Object[] objectArray3;
                if (objectArray != null && objectArray instanceof Object[] && (objectArray3 = (Object[])objectArray).length == 2 && objectArray3[0] instanceof Symbol) {
                    try {
                        objectArray = new Object[]{TranslatedDistribution.this.table.translate((Symbol)objectArray3[0]), objectArray3[1]};
                    }
                    catch (IllegalSymbolException illegalSymbolException) {
                        throw new BioError(illegalSymbolException, "Couldn't translate symbol");
                    }
                }
                if (objectArray2 != null && objectArray2 instanceof Object[] && (objectArray3 = (Object[])objectArray2).length == 2 && objectArray3[0] instanceof Symbol) {
                    try {
                        objectArray2 = new Object[]{TranslatedDistribution.this.table.translate((Symbol)objectArray3[0]), objectArray3[1]};
                    }
                    catch (IllegalSymbolException illegalSymbolException) {
                        throw new BioError(illegalSymbolException, "Couldn't translate symbol");
                    }
                }
            } else if (changeType == Distribution.NULL_MODEL) {
                objectArray = null;
                objectArray2 = null;
            }
            return new ChangeEvent(TranslatedDistribution.this, changeType, objectArray, objectArray2, changeEvent);
        }

        public void postChange(ChangeEvent changeEvent) {
            if (TranslatedDistribution.this.changeSupport != null) {
                ChangeEvent changeEvent2 = this.generateChangeEvent(changeEvent);
                ChangeSupport changeSupport = TranslatedDistribution.this.changeSupport;
                synchronized (changeSupport) {
                    TranslatedDistribution.this.changeSupport.firePostChangeEvent(changeEvent2);
                }
            }
        }

        public void preChange(ChangeEvent changeEvent) throws ChangeVetoException {
            if (TranslatedDistribution.this.changeSupport != null) {
                ChangeEvent changeEvent2 = this.generateChangeEvent(changeEvent);
                ChangeSupport changeSupport = TranslatedDistribution.this.changeSupport;
                synchronized (changeSupport) {
                    TranslatedDistribution.this.changeSupport.firePreChangeEvent(changeEvent2);
                }
            }
        }
    }
}

