/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent;

import edu.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import edu.oswego.cs.dl.util.concurrent.Heap;
import edu.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import java.util.Date;

public class TimeDaemon
extends ThreadFactoryUser {
    protected final Heap heap_ = new Heap(DefaultChannelCapacity.get());
    protected Thread thread_;
    protected final RunLoop runLoop_ = new RunLoop();

    public static void cancel(Object object) {
        ((TaskNode)object).setCancelled();
    }

    protected synchronized void clearThread() {
        this.thread_ = null;
    }

    public Object executeAfterDelay(long l, Runnable runnable) {
        long l2 = System.currentTimeMillis() + l;
        TaskNode taskNode = new TaskNode(l2, runnable);
        this.heap_.insert(taskNode);
        this.restart();
        return taskNode;
    }

    public Object executeAt(Date date, Runnable runnable) {
        TaskNode taskNode = new TaskNode(date.getTime(), runnable);
        this.heap_.insert(taskNode);
        this.restart();
        return taskNode;
    }

    public Object executePeriodically(long l, Runnable runnable, boolean bl) {
        if (l <= 0L) {
            throw new IllegalArgumentException();
        }
        long l2 = System.currentTimeMillis();
        if (!bl) {
            l2 += l;
        }
        TaskNode taskNode = new TaskNode(l2, runnable, l);
        this.heap_.insert(taskNode);
        this.restart();
        return taskNode;
    }

    public synchronized Thread getThread() {
        return this.thread_;
    }

    protected synchronized TaskNode nextTask() {
        try {
            while (true) {
                if (Thread.interrupted()) {
                    return null;
                }
                long l = 0L;
                TaskNode taskNode = (TaskNode)this.heap_.peek();
                if (taskNode != null) {
                    long l2 = System.currentTimeMillis();
                    long l3 = taskNode.getTimeToRun();
                    if (l3 > l2) {
                        l = l3 - l2;
                    } else {
                        taskNode = (TaskNode)this.heap_.extract();
                        if (taskNode != null) {
                            if (taskNode.getCancelled()) {
                                l = -1L;
                            } else {
                                if (taskNode.period > 0L) {
                                    taskNode.setTimeToRun(l2 + taskNode.period);
                                    this.heap_.insert(taskNode);
                                }
                                return taskNode;
                            }
                        }
                    }
                }
                if (l < 0L) continue;
                this.wait(l);
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    protected synchronized void restart() {
        if (this.thread_ == null) {
            this.thread_ = this.threadFactory_.newThread(this.runLoop_);
            this.thread_.start();
        } else {
            this.notify();
        }
    }

    public synchronized void shutDown() {
        this.heap_.clear();
        if (this.thread_ != null) {
            this.thread_.interrupt();
        }
    }

    protected class RunLoop
    implements Runnable {
        protected RunLoop() {
        }

        public void run() {
            try {
                TaskNode taskNode;
                while ((taskNode = TimeDaemon.this.nextTask()) != null) {
                    taskNode.command.run();
                }
                Object var3_2 = null;
                TimeDaemon.this.clearThread();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                TimeDaemon.this.clearThread();
                throw throwable;
            }
        }
    }

    protected static class TaskNode
    implements Comparable {
        final Runnable command;
        final long period;
        private long timeToRun_;
        private boolean cancelled_ = false;

        synchronized void setCancelled() {
            this.cancelled_ = true;
        }

        synchronized boolean getCancelled() {
            return this.cancelled_;
        }

        synchronized void setTimeToRun(long l) {
            this.timeToRun_ = l;
        }

        synchronized long getTimeToRun() {
            return this.timeToRun_;
        }

        public int compareTo(Object object) {
            long l;
            long l2 = this.getTimeToRun();
            return l2 < (l = ((TaskNode)object).getTimeToRun()) ? -1 : (l2 == l ? 0 : 1);
        }

        TaskNode(long l, Runnable runnable, long l2) {
            this.timeToRun_ = l;
            this.command = runnable;
            this.period = l2;
        }

        TaskNode(long l, Runnable runnable) {
            this.timeToRun_ = l;
            this.command = runnable;
            this.period = -1L;
        }
    }
}

