/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.datastructures.d2;

import fr.cea.ig.metatarget.datastructures.Sequence;
import fr.cea.ig.metatarget.datastructures.d2.SequenceD2;
import fr.cea.ig.metatarget.datastructures.d2.SequenceD2Interface;
import gnu.trove.iterator.TLongDoubleIterator;
import java.nio.ByteBuffer;

public class SequenceD2Centroid
extends SequenceD2 {
    private long numOfElements = 0L;
    private long As = 0L;
    private long Ts = 0L;
    private long Cs = 0L;
    private long Gs = 0L;

    public SequenceD2Centroid(Sequence sequence) {
        super(sequence);
    }

    @Override
    public long getAs() {
        return this.As;
    }

    @Override
    public long getTs() {
        return this.Ts;
    }

    @Override
    public long getCs() {
        return this.Cs;
    }

    @Override
    public long getGs() {
        return this.Gs;
    }

    @Override
    public long getNumOfElements() {
        return this.numOfElements;
    }

    @Override
    public long getTotalATCG() {
        return this.As + this.Ts + this.Cs + this.Gs;
    }

    public void addWith(SequenceD2Interface other, boolean adjust) {
        if (other == null) {
            return;
        }
        if (other instanceof SequenceD2Centroid) {
            // empty if block
        }
        super.addWith((SequenceD2)other);
        this.numOfElements += other.getNumOfElements();
        this.As += other.getAs();
        this.Ts += other.getTs();
        this.Cs += other.getCs();
        this.Gs += other.getGs();
        TLongDoubleIterator it = other.iteratorProbs();
        while (it.hasNext()) {
            it.advance();
            if (adjust) {
                this.adjustKmerProb(it.key(), it.value());
                continue;
            }
            this.insertKmerProb(it.key(), it.value());
        }
    }

    @Override
    public double calculateProbs(int k) {
        double sum = 0.0;
        long Total = this.getTotalATCG();
        ByteBuffer bb = ByteBuffer.wrap(new byte[8]);
        TLongDoubleIterator it = this.iteratorProbs();
        while (it.hasNext()) {
            it.advance();
            long kmerCode = it.key();
            ((ByteBuffer)bb.position(0)).putDouble(this.getDoubleProbForKmerCode(kmerCode)).position(0);
            short a = bb.getShort();
            short t = bb.getShort();
            short c = bb.getShort();
            short g = bb.getShort();
            double prob = Math.pow((double)this.As / (double)Total, a);
            prob *= Math.pow((double)this.Ts / (double)Total, t);
            prob *= Math.pow((double)this.Cs / (double)Total, c);
            this.insertKmerProbForce(kmerCode, prob *= Math.pow((double)this.Gs / (double)Total, g));
            sum += prob;
        }
        System.out.println("sumprob=" + sum);
        return sum;
    }
}

