/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.datastructures;

import fr.cea.ig.metatarget.datastructures.FastaIterator;
import fr.cea.ig.metatarget.datastructures.GeneralTools;
import fr.cea.ig.metatarget.datastructures.Sequence;
import fr.cea.ig.metatarget.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class FastaManager
implements Runnable {
    private BlockingQueue<Sequence> sequences = null;
    private List<Sequence> staticSequences = null;
    private AtomicInteger lineCount = new AtomicInteger(0);
    private AtomicInteger lineMilCount = new AtomicInteger(0);
    private AtomicInteger currSequenceId = new AtomicInteger(0);
    public boolean isFastq = false;
    private boolean keepQualities = false;
    private List<String> inputFileNames = null;
    private boolean done = false;
    private CountDownLatch startSignal = null;
    private CountDownLatch doneSignal = null;

    public FastaManager(boolean keepQualities, List<String> inputFileNames, CountDownLatch startSignal, CountDownLatch doneSignal) {
        this.keepQualities = keepQualities;
        this.inputFileNames = inputFileNames;
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
        this.sequences = new LinkedBlockingQueue<Sequence>();
        this.staticSequences = new ArrayList<Sequence>();
    }

    public void clear() {
        if (this.sequences != null) {
            this.sequences.clear();
        }
        this.sequences = new LinkedBlockingQueue<Sequence>();
        if (this.staticSequences != null) {
            this.staticSequences.clear();
        }
        this.staticSequences = new ArrayList<Sequence>();
    }

    public final List<Sequence> getStaticSequences() {
        return this.staticSequences;
    }

    public boolean hasMore() {
        if (!this.done) {
            return true;
        }
        return !this.sequences.isEmpty();
    }

    private boolean putSequence(Sequence sequence) {
        try {
            if (sequence == null || sequence.getSeq() == null || sequence.getHeader() == null) {
                return false;
            }
            this.sequences.put(sequence);
            this.staticSequences.add(sequence);
            return true;
        }
        catch (Exception e) {
            this.sequences.remove(sequence);
            this.staticSequences.remove(sequence);
            return false;
        }
    }

    public Sequence getNextSequence() {
        try {
            return this.sequences.poll(100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean addSequence(byte[] header, byte[] seq) {
        return this.addSequence(header, seq, null);
    }

    private boolean addSequence(byte[] header, byte[] seq, byte[] qual) {
        try {
            boolean ret = true;
            int seqId = this.currSequenceId.incrementAndGet();
            Sequence sequence = qual == null ? new Sequence(seqId, header, seq) : new Sequence(seqId, header, seq, qual);
            if (!this.putSequence(sequence)) {
                this.currSequenceId.decrementAndGet();
                ret = false;
            }
            return ret;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void run() {
        try {
            this.done = false;
            System.err.println(GeneralTools.time() + " FastaManager: START READ");
            this.startSignal.countDown();
            ArrayList<File> inputFiles = new ArrayList<File>();
            for (String inputFileName : this.inputFileNames) {
                if ((inputFileName = inputFileName.trim()).contains(".fastq") || inputFileName.contains(".fq")) {
                    this.isFastq = true;
                } else if (inputFileName.contains(".fasta") || inputFileName.contains(".fa")) {
                    this.isFastq = false;
                }
                File f = new File(inputFileName);
                if (!f.exists() || !f.canRead()) {
                    System.err.println("\tERROR : File " + f + "\n\tdoes not exist ot cannot be read. Exiting.");
                    System.exit(1);
                }
                inputFiles.add(f.getCanonicalFile());
            }
            FastaIterator iterator = FastaIterator.create(inputFiles);
            for (List<byte[]> reads_chunk : iterator) {
                if (reads_chunk == null) continue;
                this.lineCount.addAndGet(reads_chunk.size());
                if (this.lineCount.get() > 500000 * this.lineMilCount.get()) {
                    this.lineMilCount.incrementAndGet();
                    System.out.println(Utils.time() + " FastaManager: lines read " + this.lineCount.get());
                }
                boolean on_qual = false;
                byte[] header = null;
                ArrayList<byte[]> seq = new ArrayList<byte[]>();
                ArrayList<byte[]> qual = new ArrayList<byte[]>();
                if (!this.isFastq) {
                    for (byte[] line : reads_chunk) {
                        if (line.length == 0) continue;
                        if (line[0] == 62) {
                            if (!seq.isEmpty()) {
                                this.addSequence(header, GeneralTools.concat(seq));
                                seq.clear();
                            }
                            header = line;
                            continue;
                        }
                        seq.add(line);
                    }
                    if (seq.isEmpty()) continue;
                    this.addSequence(header, GeneralTools.concat(seq));
                    seq.clear();
                    continue;
                }
                for (byte[] line : reads_chunk) {
                    if (line.length == 0) continue;
                    if (line[0] == 64) {
                        if (!seq.isEmpty() && !qual.isEmpty()) {
                            if (this.keepQualities) {
                                this.addSequence(header, GeneralTools.concat(seq), GeneralTools.concat(qual));
                            } else {
                                this.addSequence(header, GeneralTools.concat(seq));
                            }
                            seq.clear();
                            qual.clear();
                            on_qual = false;
                        }
                        header = line;
                        continue;
                    }
                    if (line[0] == 43) {
                        on_qual = true;
                        continue;
                    }
                    if (on_qual) {
                        qual.add(line);
                        continue;
                    }
                    seq.add(line);
                }
                if (seq.isEmpty() || qual.isEmpty()) continue;
                if (this.keepQualities) {
                    this.addSequence(header, GeneralTools.concat(seq), GeneralTools.concat(qual));
                } else {
                    this.addSequence(header, GeneralTools.concat(seq));
                }
                seq.clear();
                qual.clear();
            }
            System.err.println(GeneralTools.time() + " FastaManager: END READ");
            System.err.println(GeneralTools.time() + " FastaManager: " + (this.isFastq ? "FASTQ" : "FASTA"));
            this.done = true;
            this.doneSignal.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }
}

