/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.swing;

import edu.rit.swing.Displayable;
import edu.rit.swing.DisplayableIO;
import edu.rit.swing.DisplayablePanel;
import edu.rit.swing.FileTypeFilter;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class DisplayableFrame
extends JFrame {
    private Displayable myDisplayable;
    private DisplayablePanel myDisplayablePanel;
    private JFileChooser myChooser;
    private FileTypeFilter myFilter;
    private JMenuItem myCloseMenuItem;
    private int myCloseOperation;
    private int myZoomCount = 0;
    private double myZoomFactor = 1.0;
    private JCheckBoxMenuItem myZoom13Item;
    private JCheckBoxMenuItem myZoom25Item;
    private JCheckBoxMenuItem myZoom50Item;
    private JCheckBoxMenuItem myZoom100Item;
    private JCheckBoxMenuItem myZoom200Item;
    private JCheckBoxMenuItem myZoom400Item;
    private JCheckBoxMenuItem myZoom800Item;

    public DisplayableFrame(Displayable displayable) {
        this.initialize(displayable, 2);
    }

    public DisplayableFrame(String string, Displayable displayable) {
        super(string);
        this.initialize(displayable, 2);
    }

    public DisplayableFrame(Displayable displayable, int n) {
        this.initialize(displayable, n);
    }

    public DisplayableFrame(String string, Displayable displayable, int n) {
        super(string);
        this.initialize(displayable, n);
    }

    private void initialize(Displayable displayable, int n) {
        if (displayable == null) {
            throw new NullPointerException();
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.myDisplayable = displayable;
        this.myCloseOperation = n;
        this.myChooser = new JFileChooser(System.getProperty("user.dir"));
        this.myFilter = new FileTypeFilter();
        this.myChooser.setFileFilter(this.myFilter);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Save as PNG...", 83);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayableFrame.this.doSaveAsPng();
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Save as PostScript...", 80);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayableFrame.this.doSaveAsPostScript();
            }
        });
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        this.myCloseMenuItem = new JMenuItem("Quit", 81);
        this.setDefaultCloseOperation(n);
        this.myCloseMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayableFrame.this.doClose();
            }
        });
        jMenu.add(this.myCloseMenuItem);
        JMenu jMenu2 = new JMenu("View");
        jMenu2.setMnemonic(86);
        JMenuItem jMenuItem3 = new JMenuItem("Zoom Out", 90);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(45, 2));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayableFrame.this.setZoom(DisplayableFrame.this.myZoomCount - 1);
            }
        });
        jMenu2.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Zoom In", 79);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(61, 2));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayableFrame.this.setZoom(DisplayableFrame.this.myZoomCount + 1);
            }
        });
        jMenu2.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Fit Window", 70);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayableFrame.this.doFitWindow();
            }
        });
        jMenu2.add(jMenuItem5);
        jMenu2.addSeparator();
        this.myZoom13Item = new JCheckBoxMenuItem("13%");
        this.myZoom13Item.setAccelerator(KeyStroke.getKeyStroke(56, 3));
        this.myZoom13Item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayableFrame.this.setZoom(-18);
            }
        });
        jMenu2.add(this.myZoom13Item);
        this.myZoom25Item = new JCheckBoxMenuItem("25%");
        this.myZoom25Item.setAccelerator(KeyStroke.getKeyStroke(52, 3));
        this.myZoom25Item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayableFrame.this.setZoom(-12);
            }
        });
        jMenu2.add(this.myZoom25Item);
        this.myZoom50Item = new JCheckBoxMenuItem("50%");
        this.myZoom50Item.setAccelerator(KeyStroke.getKeyStroke(50, 3));
        this.myZoom50Item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayableFrame.this.setZoom(-6);
            }
        });
        jMenu2.add(this.myZoom50Item);
        this.myZoom100Item = new JCheckBoxMenuItem("100%");
        this.myZoom100Item.setAccelerator(KeyStroke.getKeyStroke(49, 2));
        this.myZoom100Item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayableFrame.this.setZoom(0);
            }
        });
        jMenu2.add(this.myZoom100Item);
        this.myZoom200Item = new JCheckBoxMenuItem("200%");
        this.myZoom200Item.setAccelerator(KeyStroke.getKeyStroke(50, 2));
        this.myZoom200Item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayableFrame.this.setZoom(6);
            }
        });
        jMenu2.add(this.myZoom200Item);
        this.myZoom400Item = new JCheckBoxMenuItem("400%");
        this.myZoom400Item.setAccelerator(KeyStroke.getKeyStroke(52, 2));
        this.myZoom400Item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayableFrame.this.setZoom(12);
            }
        });
        jMenu2.add(this.myZoom400Item);
        this.myZoom800Item = new JCheckBoxMenuItem("800%");
        this.myZoom800Item.setAccelerator(KeyStroke.getKeyStroke(56, 2));
        this.myZoom800Item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayableFrame.this.setZoom(18);
            }
        });
        jMenu2.add(this.myZoom800Item);
        this.myZoom100Item.setSelected(true);
        jMenu2.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem("Image Info...", 73);
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayableFrame.this.doImageInfo();
            }
        });
        jMenu2.add(jMenuItem6);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.myDisplayablePanel = new DisplayablePanel(this.myDisplayable);
        JScrollPane jScrollPane = new JScrollPane(this.myDisplayablePanel, 22, 32);
        this.getContentPane().add(jScrollPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DisplayableFrame.this.doClose();
            }
        });
        this.pack();
    }

    public void setDefaultCloseOperation(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        super.setDefaultCloseOperation(n);
        this.myCloseOperation = n;
        if (n == 3) {
            this.myCloseMenuItem.setText("Quit");
            this.myCloseMenuItem.setMnemonic(81);
            this.myCloseMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        } else {
            this.myCloseMenuItem.setText("Close");
            this.myCloseMenuItem.setMnemonic(67);
            this.myCloseMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        }
    }

    public void display(Displayable displayable) {
        if (displayable == null) {
            throw new NullPointerException();
        }
        this.myDisplayable = displayable;
        this.myDisplayablePanel.display(displayable);
    }

    public void saveFile(String string, String string2, FileSaver fileSaver) {
        File file = null;
        try {
            this.myFilter.setType(string, string2);
            if (this.myChooser.showSaveDialog(this) == 0 && this.okayToWrite(file = this.myChooser.getSelectedFile())) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                fileSaver.saveFile(file);
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (Throwable throwable) {
            this.setCursor(Cursor.getDefaultCursor());
            this.displayErrorMessage(file, throwable);
        }
    }

    private void doSaveAsPng() {
        this.saveFile(".png", "PNG image files", new FileSaver(){

            public void saveFile(File file) throws IOException {
                DisplayableIO.writeColorPNGFile(DisplayableFrame.this.myDisplayable, file, DisplayableFrame.this.myZoomFactor);
            }
        });
    }

    private void doSaveAsPostScript() {
        this.saveFile(".ps", "PostScript files", new FileSaver(){

            public void saveFile(File file) throws IOException {
                DisplayableIO.writePostScriptFile(DisplayableFrame.this.myDisplayable, file);
            }
        });
    }

    private boolean okayToWrite(File file) {
        if (file.exists()) {
            try {
                return JOptionPane.showConfirmDialog(this, "Overwrite \"" + file.getName() + "\"?", "File Exists", 0, 3) == 0;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return true;
    }

    private void displayErrorMessage(File file, Throwable throwable) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cannot write file");
            if (file != null) {
                stringBuffer.append(" \"");
                stringBuffer.append(file.getName());
                stringBuffer.append("\"");
            }
            stringBuffer.append(" -- ");
            stringBuffer.append(throwable.getClass().getName());
            if (throwable.getMessage() != null) {
                stringBuffer.append(" -- ");
                stringBuffer.append(throwable.getMessage());
            }
            JOptionPane.showMessageDialog(this, stringBuffer.toString(), "Error", 0);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    private void doClose() {
        switch (this.myCloseOperation) {
            case 1: {
                this.setVisible(false);
                break;
            }
            case 2: {
                this.setVisible(false);
                this.dispose();
                break;
            }
            case 3: {
                System.exit(0);
            }
        }
    }

    private void setZoom(int n) {
        this.myZoomCount = Math.max(-18, Math.min(n, 18));
        this.myZoomFactor = Math.pow(2.0, (double)this.myZoomCount / 6.0);
        this.myDisplayablePanel.zoom(this.myZoomFactor);
        this.myZoom13Item.setSelected(this.myZoomCount == -18);
        this.myZoom25Item.setSelected(this.myZoomCount == -12);
        this.myZoom50Item.setSelected(this.myZoomCount == -6);
        this.myZoom100Item.setSelected(this.myZoomCount == 0);
        this.myZoom200Item.setSelected(this.myZoomCount == 6);
        this.myZoom400Item.setSelected(this.myZoomCount == 12);
        this.myZoom800Item.setSelected(this.myZoomCount == 18);
    }

    private void doFitWindow() {
        this.myDisplayablePanel.display(this.myDisplayable);
        this.pack();
    }

    private void doImageInfo() {
        Rectangle2D rectangle2D = this.myDisplayable.getBoundingBox();
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        JOptionPane.showMessageDialog(this, new String[]{"Width = " + d + " pt = " + d / 72.0 + " in", "Height = " + d2 + " pt = " + d2 / 72.0 + " in"}, "Image Info", 1);
    }

    public static interface FileSaver {
        public void saveFile(File var1) throws IOException;
    }
}

