/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.monte;

import edu.rit.pj.LongForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedLong;
import java.util.Random;

public class PiSmp2 {
    static long seed;
    static long N;
    static SharedLong count;

    private PiSmp2() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = -System.currentTimeMillis();
        if (stringArray.length != 2) {
            PiSmp2.usage();
        }
        seed = Long.parseLong(stringArray[0]);
        N = Long.parseLong(stringArray[1]);
        count = new SharedLong(0L);
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                this.execute(0L, N - 1L, new LongForLoop(){
                    Random prng_thread = new Random(seed);
                    long count_thread = 0L;
                    long pad0;
                    long pad1;
                    long pad2;
                    long pad3;
                    long pad4;
                    long pad5;
                    long pad6;
                    long pad7;
                    long pad8;
                    long pad9;
                    long pada;
                    long padb;
                    long padc;
                    long padd;
                    long pade;
                    long padf;

                    public void run(long l, long l2) {
                        for (long i = l; i <= l2; ++i) {
                            double d;
                            double d2 = this.prng_thread.nextDouble();
                            if (!(d2 * d2 + (d = this.prng_thread.nextDouble()) * d <= 1.0)) continue;
                            ++this.count_thread;
                        }
                    }

                    public void finish() {
                        count.addAndGet(this.count_thread);
                    }
                });
            }
        });
        System.out.println("pi = 4 * " + count + " / " + N + " = " + 4.0 * count.doubleValue() / (double)N);
        System.out.println((l += System.currentTimeMillis()) + " msec");
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.nt=<K> edu.rit.smp.monte.PiSmp2 <seed> <N>");
        System.err.println("<K> = Number of parallel threads");
        System.err.println("<seed> = Random seed");
        System.err.println("<N> = Number of random points");
        System.exit(1);
    }
}

