/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.ca;

import edu.rit.image.GrayImageRow;
import edu.rit.image.PJGGrayImage;
import edu.rit.image.PJGImage;
import edu.rit.numeric.BigRational;
import edu.rit.util.Range;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class CCASeq {
    static final BigRational ZERO = new BigRational("0");
    static final BigRational ONE = new BigRational("1");
    static final BigRational ONE_THIRD = new BigRational("1/3");
    static int C;
    static int S;
    static BigRational A;
    static BigRational B;
    static File imagefile;
    static BigRational[] currentCell;
    static BigRational[] nextCell;
    static byte[][] pixelmatrix;
    static PJGGrayImage image;
    static PJGImage.Writer writer;
    static byte[] pixelrow;
    static GrayImageRow imagerow;

    private CCASeq() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        long l = System.currentTimeMillis();
        if (stringArray.length != 5) {
            CCASeq.usage();
        }
        C = Integer.parseInt(stringArray[0]);
        S = Integer.parseInt(stringArray[1]);
        A = new BigRational(stringArray[2]).mul(ONE_THIRD);
        B = new BigRational(stringArray[3]);
        imagefile = new File(stringArray[4]);
        currentCell = new BigRational[C];
        nextCell = new BigRational[C];
        for (n = 0; n < C; ++n) {
            CCASeq.currentCell[n] = new BigRational();
            CCASeq.nextCell[n] = new BigRational();
        }
        currentCell[C / 2].assign(ONE);
        pixelmatrix = new byte[S + 1][];
        image = new PJGGrayImage(S + 1, C, pixelmatrix);
        writer = image.prepareToWrite(new BufferedOutputStream(new FileOutputStream(imagefile)));
        pixelrow = new byte[C];
        imagerow = new GrayImageRow(pixelrow);
        imagerow.setInterpretation(PJGGrayImage.ZERO_IS_WHITE);
        for (n = 0; n < S; ++n) {
            for (int i = 0; i < C; ++i) {
                nextCell[i].assign(currentCell[i]).add(currentCell[(i - 1 + C) % C]).add(currentCell[(i + 1) % C]).mul(A).add(B).normalize().fracPart();
            }
            CCASeq.writeCurrentCell(n);
            BigRational[] bigRationalArray = currentCell;
            currentCell = nextCell;
            nextCell = bigRationalArray;
        }
        CCASeq.writeCurrentCell(S);
        writer.close();
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec total");
    }

    private static void writeCurrentCell(int n) throws IOException {
        for (int i = 0; i < C; ++i) {
            imagerow.setPixel(i, currentCell[i].floatValue());
        }
        CCASeq.pixelmatrix[n] = pixelrow;
        writer.writeRowSlice(new Range(n, n));
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.smp.ca.CCASeq <C> <S> <A> <B> <imagefile>");
        System.err.println("<C> = Number of cells (>= 1)");
        System.err.println("<S> = Number of time steps (>= 1)");
        System.err.println("<A> = Multiplicand in update formula (rational number)");
        System.err.println("<B> = Addend in update formula (rational number)");
        System.err.println("<imagefile> = Output PJG image file name");
        System.exit(1);
    }
}

