/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.LongItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.LongOp;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class ReplicatedLong
extends Number {
    private LongOp myOp;
    private AtomicLong myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedLong(LongOp longOp) {
        this(longOp, 0L, 0, Comm.world());
    }

    public ReplicatedLong(LongOp longOp, long l) {
        this(longOp, l, 0, Comm.world());
    }

    public ReplicatedLong(LongOp longOp, long l, int n) {
        this(longOp, l, n, Comm.world());
    }

    public ReplicatedLong(LongOp longOp, long l, int n, Comm comm) {
        if (longOp == null) {
            throw new NullPointerException("ReplicatedLong(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedLong(): comm is null");
        }
        this.myOp = longOp;
        this.myValue = new AtomicLong(l);
        this.myTag = n;
        this.myComm = comm;
        this.myReceiver = new Receiver();
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public long get() {
        return this.myValue.get();
    }

    public long reduce(long l) throws IOException {
        long l2;
        long l3;
        while (!this.myValue.compareAndSet(l3 = this.myValue.get(), l2 = this.myOp.op(l3, l))) {
        }
        if (l2 != l3) {
            this.myComm.floodSend(this.myTag, LongBuf.buffer(l2));
        }
        return l2;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    public int intValue() {
        return (int)this.get();
    }

    public long longValue() {
        return this.get();
    }

    public float floatValue() {
        return this.get();
    }

    public double doubleValue() {
        return this.get();
    }

    private class Receiver
    extends Thread {
        private Receiver() {
        }

        public void run() {
            LongItemBuf longItemBuf = LongBuf.buffer();
            try {
                while (true) {
                    long l;
                    long l2;
                    ReplicatedLong.this.myComm.floodReceive(ReplicatedLong.this.myTag, longItemBuf);
                    do {
                        l2 = ReplicatedLong.this.myValue.get();
                        l = ReplicatedLong.this.myOp.op(l2, longItemBuf.item);
                    } while (!ReplicatedLong.this.myValue.compareAndSet(l2, l));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                return;
            }
        }
    }
}

