/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.IntegerOp;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SharedIntegerMatrix {
    private AtomicIntegerArray[] myMatrix;

    public SharedIntegerMatrix(int n, int n2) {
        this.myMatrix = new AtomicIntegerArray[n];
        for (int i = 0; i < n; ++i) {
            this.myMatrix[i] = new AtomicIntegerArray(n2);
        }
    }

    public SharedIntegerMatrix(int[][] nArray) {
        this.myMatrix = new AtomicIntegerArray[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.myMatrix[i] = new AtomicIntegerArray(nArray[i]);
        }
    }

    public int rows() {
        return this.myMatrix.length;
    }

    public int cols() {
        return this.myMatrix[0].length();
    }

    public int get(int n, int n2) {
        return this.myMatrix[n].get(n2);
    }

    public void set(int n, int n2, int n3) {
        this.myMatrix[n].set(n2, n3);
    }

    public int getAndSet(int n, int n2, int n3) {
        return this.myMatrix[n].getAndSet(n2, n3);
    }

    public boolean compareAndSet(int n, int n2, int n3, int n4) {
        return this.myMatrix[n].compareAndSet(n2, n3, n4);
    }

    public boolean weakCompareAndSet(int n, int n2, int n3, int n4) {
        return this.myMatrix[n].weakCompareAndSet(n2, n3, n4);
    }

    public int getAndIncrement(int n, int n2) {
        return this.myMatrix[n].getAndIncrement(n2);
    }

    public int getAndDecrement(int n, int n2) {
        return this.myMatrix[n].getAndDecrement(n2);
    }

    public int getAndAdd(int n, int n2, int n3) {
        return this.myMatrix[n].getAndAdd(n2, n3);
    }

    public int incrementAndGet(int n, int n2) {
        return this.myMatrix[n].incrementAndGet(n2);
    }

    public int decrementAndGet(int n, int n2) {
        return this.myMatrix[n].decrementAndGet(n2);
    }

    public int addAndGet(int n, int n2, int n3) {
        return this.myMatrix[n].addAndGet(n2, n3);
    }

    public int reduce(int n, int n2, int n3, IntegerOp integerOp) {
        int n4;
        int n5;
        AtomicIntegerArray atomicIntegerArray = this.myMatrix[n];
        while (!atomicIntegerArray.compareAndSet(n2, n5 = atomicIntegerArray.get(n2), n4 = integerOp.op(n5, n3))) {
        }
        return n4;
    }

    public void reduce(int[][] nArray, IntegerOp integerOp) {
        this.reduce(0, 0, nArray, 0, 0, this.rows(), this.cols(), integerOp);
    }

    public void reduce(int n, int n2, int[][] nArray, int n3, int n4, int n5, int n6, IntegerOp integerOp) {
        if (n5 < 0 || n6 < 0 || n < 0 || n + n5 > this.rows() || n2 < 0 || n2 + n6 > this.cols() || n3 < 0 || n3 + n5 > nArray.length || n4 < 0 || n4 + n6 > nArray[0].length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n5; ++i) {
            AtomicIntegerArray atomicIntegerArray = this.myMatrix[n + i];
            int[] nArray2 = nArray[n3 + i];
            for (int j = 0; j < n6; ++j) {
                int n7;
                int n8;
                int n9 = n2 + j;
                int n10 = nArray2[n4 + j];
                while (!atomicIntegerArray.compareAndSet(n9, n8 = atomicIntegerArray.get(n9), n7 = integerOp.op(n8, n10))) {
                }
            }
        }
    }
}

