/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.BackendInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private String myClusterName;
    private String myLogFile;
    private String myWebHost = "0.0.0.0";
    private int myWebPort = 8080;
    private String mySchedulerHost = "localhost";
    private int mySchedulerPort = 20617;
    private String myFrontendHost;
    private ArrayList<BackendInfo> myBackendInfo = new ArrayList();
    private static final String DEFAULT_SHELL_COMMAND = "bash -l -c";
    private int myJobTime;

    public Configuration(String string) throws IOException {
        this.parseConfigFile(string);
    }

    public String getClusterName() {
        return this.myClusterName;
    }

    public String getLogFile() {
        return this.myLogFile;
    }

    public String getWebHost() {
        return this.myWebHost;
    }

    public int getWebPort() {
        return this.myWebPort;
    }

    public String getSchedulerHost() {
        return this.mySchedulerHost;
    }

    public int getSchedulerPort() {
        return this.mySchedulerPort;
    }

    public String getFrontendHost() {
        return this.myFrontendHost;
    }

    public int getBackendCount() {
        return this.myBackendInfo.size();
    }

    public BackendInfo getBackendInfo(int n) {
        return this.myBackendInfo.get(n);
    }

    public List<BackendInfo> getBackendInfoList() {
        return this.myBackendInfo;
    }

    public int getJobTime() {
        return this.myJobTime;
    }

    private void parseConfigFile(String string) throws IOException {
        Scanner scanner = null;
        String string2 = null;
        long l = System.currentTimeMillis();
        try {
            scanner = new Scanner(new File(string));
            while (scanner.hasNextLine()) {
                Object object;
                String string3;
                string2 = scanner.nextLine();
                Scanner scanner2 = new Scanner(string2);
                if (!scanner2.hasNext() || (string3 = scanner2.next()).charAt(0) == '#') continue;
                if (string3.equals("cluster")) {
                    this.myClusterName = scanner2.nextLine().trim();
                    continue;
                }
                if (string3.equals("logfile")) {
                    this.myLogFile = scanner2.next();
                    continue;
                }
                if (string3.equals("webhost")) {
                    this.myWebHost = scanner2.next();
                    continue;
                }
                if (string3.equals("webport")) {
                    this.myWebPort = Integer.parseInt(scanner2.next());
                    continue;
                }
                if (string3.equals("schedulerhost")) {
                    this.mySchedulerHost = scanner2.next();
                    continue;
                }
                if (string3.equals("schedulerport")) {
                    this.mySchedulerPort = Integer.parseInt(scanner2.next());
                    continue;
                }
                if (string3.equals("frontendhost")) {
                    this.myFrontendHost = scanner2.next();
                    continue;
                }
                if (string3.equals("backend")) {
                    String string4 = scanner2.next();
                    int n = scanner2.nextInt();
                    if (n < 1) {
                        throw new IOException("Invalid backend command, <cpus> must be >= 1: " + string2);
                    }
                    object = scanner2.next();
                    String string5 = scanner2.next();
                    String string6 = scanner2.next();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (scanner2.hasNext()) {
                        arrayList.add(scanner2.next());
                    }
                    BackendInfo backendInfo = new BackendInfo(string4, n, BackendInfo.State.IDLE, l, (String)object, string5, string6, arrayList.toArray(new String[arrayList.size()]), DEFAULT_SHELL_COMMAND);
                    this.myBackendInfo.add(backendInfo);
                    continue;
                }
                if (string3.equals("backendshell")) {
                    String string7 = scanner2.next();
                    String string8 = scanner2.nextLine().trim();
                    object = this.backendInfoForName(string7);
                    if (object == null) {
                        throw new IOException("Invalid backendshell command, no backend named \"" + string7 + "\"");
                    }
                    ((BackendInfo)object).shellCommand = string8;
                    continue;
                }
                if (string3.equals("jobtime")) {
                    int n = scanner2.nextInt();
                    if (n < 1) {
                        throw new IOException("Invalid configuration command: " + string2);
                    }
                    this.myJobTime = n;
                    continue;
                }
                throw new IOException("Invalid configuration command: " + string2);
            }
            if (this.myClusterName == null) {
                throw new IOException("Missing configuration command: cluster <name>");
            }
            if (this.myLogFile == null) {
                throw new IOException("Missing configuration command: logfile <file>");
            }
            if (this.myWebHost == null) {
                throw new IOException("Missing configuration command: webhost <host>");
            }
            if (this.myFrontendHost == null) {
                throw new IOException("Missing configuration command: frontendhost <host>");
            }
            if (this.myBackendInfo.isEmpty()) {
                throw new IOException("Missing configuration command: backend <name> <host> <port>");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IOException("Invalid configuration command: " + string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Invalid configuration command: " + string2);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    private BackendInfo backendInfoForName(String string) {
        for (BackendInfo backendInfo : this.myBackendInfo) {
            if (!backendInfo.name.equals(string)) continue;
            return backendInfo;
        }
        return null;
    }
}

