/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.ResourceCache;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackendClassLoader
extends ClassLoader {
    private JobBackendRef myJobBackend;
    private JobFrontendRef myJobFrontend;
    private ResourceCache myCache;
    private Map<String, URL> myResourceURLMap = Collections.synchronizedMap(new HashMap());

    public BackendClassLoader(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef, ResourceCache resourceCache) {
        this.myJobBackend = jobBackendRef;
        this.myJobFrontend = jobFrontendRef;
        this.myCache = resourceCache;
    }

    public BackendClassLoader(ClassLoader classLoader, JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef, ResourceCache resourceCache) {
        super(classLoader);
        this.myJobBackend = jobBackendRef;
        this.myJobFrontend = jobFrontendRef;
        this.myCache = resourceCache;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        try {
            byte[] byArray;
            String string2 = string.replace('.', '/') + ".class";
            if (!this.myCache.contains(string2)) {
                this.myJobFrontend.requestResource(this.myJobBackend, string2);
            }
            if ((byArray = this.myCache.get(string2)) == null) {
                throw new ClassNotFoundException("Class " + string + " not found");
            }
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Class " + string + " not found due to I/O error", iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new ClassNotFoundException("Class " + string + " not found because thread interrupted", interruptedException);
        }
    }

    @Override
    protected URL findResource(String string) {
        try {
            URL uRL = this.myResourceURLMap.get(string);
            if (uRL == null) {
                byte[] byArray;
                if (!this.myCache.contains(string)) {
                    this.myJobFrontend.requestResource(this.myJobBackend, string);
                }
                if ((byArray = this.myCache.get(string)) == null) {
                    return null;
                }
                String string2 = new File(string).getName();
                int n = string2.lastIndexOf(46);
                String string3 = n == -1 ? string2 : string2.substring(0, n);
                String string4 = n == -1 ? null : string2.substring(n);
                File file = File.createTempFile(string3 + "_tmp", string4);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                ((OutputStream)bufferedOutputStream).write(byArray);
                ((OutputStream)bufferedOutputStream).close();
                file.deleteOnExit();
                uRL = file.toURI().toURL();
                this.myResourceURLMap.put(string, uRL);
            }
            return uRL;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }
}

