/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.Comm;
import edu.rit.pj.MultipleParallelException;
import edu.rit.pj.WorkerRegion;
import edu.rit.pj.WorkerTeamThread;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public class WorkerTeam {
    int K;
    Comm comm;
    int size;
    int rank;
    int count;
    WorkerTeamThread[] myThread;
    WorkerRegion myRegion;
    Semaphore myRegionEndSemaphore = new Semaphore(0);
    ConcurrentHashMap<Integer, Throwable> myExceptionMap;

    WorkerTeam(boolean bl) {
    }

    public WorkerTeam() {
        this(Comm.world());
    }

    public WorkerTeam(Comm comm) {
        if (comm == null) {
            throw new NullPointerException("WorkerTeam(): comm is null");
        }
        this.initialize(1, comm, comm.size(), comm.rank(), comm.size(), comm.rank());
    }

    void initialize(int n, Comm comm, int n2, int n3, int n4, int n5) {
        this.K = n;
        this.comm = comm;
        this.size = n2;
        this.rank = n3;
        this.count = n4;
        int n6 = n + (n3 == 0 ? 1 : 0);
        this.myThread = new WorkerTeamThread[n6];
        for (int i = 0; i < n; ++i) {
            this.myThread[i] = new WorkerTeamThread(this, n5 + i);
        }
        if (n6 > n) {
            this.myThread[n] = new WorkerTeamThread(this, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(WorkerRegion workerRegion) throws Exception {
        if (workerRegion == null) {
            throw new NullPointerException("WorkerTeam.execute(): theRegion is null");
        }
        if (this.myRegion != null) {
            throw new IllegalStateException("WorkerTeam.execute(): Already executing a worker region");
        }
        if (workerRegion.myTeam != null) {
            throw new IllegalStateException("WorkerTeam.execute(): theRegion already being executed by a worker team");
        }
        this.myRegion = workerRegion;
        this.myExceptionMap = new ConcurrentHashMap(this.K, 0.75f, this.K);
        workerRegion.myTeam = this;
        try {
            this.myRegion.start();
            for (WorkerTeamThread workerTeamThread : this.myThread) {
                workerTeamThread.myRegionBeginSemaphore.release();
            }
            this.myRegionEndSemaphore.acquireUninterruptibly(this.myThread.length);
            if (!this.myExceptionMap.isEmpty()) {
                if (this.myExceptionMap.size() == 1) {
                    WorkerTeam.rethrow(this.myExceptionMap.values().iterator().next());
                } else {
                    throw new MultipleParallelException("WorkerTeam.execute(): Multiple threads threw exceptions", this.myExceptionMap);
                }
            }
            this.myRegion.finish();
        }
        finally {
            this.myRegion.myTeam = null;
            this.myExceptionMap = null;
            this.myRegion = null;
        }
    }

    public final boolean isExecutingInParallel() {
        return this.myRegion != null;
    }

    public final WorkerRegion region() {
        if (this.myRegion == null) {
            throw new IllegalStateException("WorkerTeam.region(): Not executing a worker region");
        }
        return this.myRegion;
    }

    public final int getThreadCount() {
        return this.K;
    }

    public final int getTotalThreadCount() {
        return this.count;
    }

    public int masterRank() {
        return 0;
    }

    public int workerRank(int n) {
        if (0 > n || n >= this.count) {
            throw new IllegalArgumentException("WorkerTeam.workerRank(): w (= " + n + ") illegal");
        }
        return n;
    }

    static void rethrow(Object object) throws Exception {
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof Exception) {
            throw (Exception)object;
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
    }
}

