/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.Series;
import edu.rit.numeric.XYSeries;
import java.io.PrintStream;
import java.io.PrintWriter;

public abstract class XYSeriesComplex {
    public abstract int length();

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public abstract double x(int var1);

    public abstract double real(int var1);

    public abstract double imag(int var1);

    public double magnitude(int n) {
        double d = this.real(n);
        double d2 = this.imag(n);
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        if (d3 == 0.0) {
            return d4;
        }
        if (d4 == 0.0) {
            return d3;
        }
        if (d3 >= d4) {
            double d5 = d2 / d;
            return d3 * Math.sqrt(1.0 + d5 * d5);
        }
        double d6 = d / d2;
        return d4 * Math.sqrt(1.0 + d6 * d6);
    }

    public double squaredMagnitude(int n) {
        double d = this.real(n);
        double d2 = this.imag(n);
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        if (d3 == 0.0) {
            return d4 * d4;
        }
        if (d4 == 0.0) {
            return d3 * d3;
        }
        if (d3 >= d4) {
            double d5 = d2 / d;
            return d3 * d3 * (1.0 + d5 * d5);
        }
        double d6 = d / d2;
        return d4 * d4 * (1.0 + d6 * d6);
    }

    public double phase(int n) {
        return Math.atan2(this.imag(n), this.real(n));
    }

    public Series realSeries() {
        final XYSeriesComplex xYSeriesComplex = this;
        return new Series(){

            public int length() {
                return xYSeriesComplex.length();
            }

            public double x(int n) {
                return xYSeriesComplex.real(n);
            }
        };
    }

    public Series imagSeries() {
        final XYSeriesComplex xYSeriesComplex = this;
        return new Series(){

            public int length() {
                return xYSeriesComplex.length();
            }

            public double x(int n) {
                return xYSeriesComplex.imag(n);
            }
        };
    }

    public Series magnitudeSeries() {
        final XYSeriesComplex xYSeriesComplex = this;
        return new Series(){

            public int length() {
                return xYSeriesComplex.length();
            }

            public double x(int n) {
                return xYSeriesComplex.magnitude(n);
            }
        };
    }

    public Series squaredMagnitudeSeries() {
        final XYSeriesComplex xYSeriesComplex = this;
        return new Series(){

            public int length() {
                return xYSeriesComplex.length();
            }

            public double x(int n) {
                return xYSeriesComplex.squaredMagnitude(n);
            }
        };
    }

    public Series phaseSeries() {
        final XYSeriesComplex xYSeriesComplex = this;
        return new Series(){

            public int length() {
                return xYSeriesComplex.length();
            }

            public double x(int n) {
                return xYSeriesComplex.phase(n);
            }
        };
    }

    public XYSeries realXYSeries() {
        final XYSeriesComplex xYSeriesComplex = this;
        return new XYSeries(){

            public int length() {
                return xYSeriesComplex.length();
            }

            public double x(int n) {
                return xYSeriesComplex.x(n);
            }

            public double y(int n) {
                return xYSeriesComplex.real(n);
            }
        };
    }

    public XYSeries imagXYSeries() {
        final XYSeriesComplex xYSeriesComplex = this;
        return new XYSeries(){

            public int length() {
                return xYSeriesComplex.length();
            }

            public double x(int n) {
                return xYSeriesComplex.x(n);
            }

            public double y(int n) {
                return xYSeriesComplex.imag(n);
            }
        };
    }

    public XYSeries magnitudeXYSeries() {
        final XYSeriesComplex xYSeriesComplex = this;
        return new XYSeries(){

            public int length() {
                return xYSeriesComplex.length();
            }

            public double x(int n) {
                return xYSeriesComplex.x(n);
            }

            public double y(int n) {
                return xYSeriesComplex.magnitude(n);
            }
        };
    }

    public XYSeries squaredMagnitudeXYSeries() {
        final XYSeriesComplex xYSeriesComplex = this;
        return new XYSeries(){

            public int length() {
                return xYSeriesComplex.length();
            }

            public double x(int n) {
                return xYSeriesComplex.x(n);
            }

            public double y(int n) {
                return xYSeriesComplex.squaredMagnitude(n);
            }
        };
    }

    public XYSeries phaseXYSeries() {
        final XYSeriesComplex xYSeriesComplex = this;
        return new XYSeries(){

            public int length() {
                return xYSeriesComplex.length();
            }

            public double x(int n) {
                return xYSeriesComplex.x(n);
            }

            public double y(int n) {
                return xYSeriesComplex.phase(n);
            }
        };
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream printStream) {
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            printStream.print(i);
            printStream.print('\t');
            printStream.print(this.x(i));
            printStream.print('\t');
            printStream.print(this.real(i));
            printStream.print('\t');
            printStream.print(this.imag(i));
            printStream.print('\t');
            printStream.print(this.magnitude(i));
            printStream.print('\t');
            printStream.println(this.phase(i));
        }
    }

    public void print(PrintWriter printWriter) {
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            printWriter.print(i);
            printWriter.print('\t');
            printWriter.print(this.x(i));
            printWriter.print('\t');
            printWriter.print(this.real(i));
            printWriter.print('\t');
            printWriter.print(this.imag(i));
            printWriter.print('\t');
            printWriter.print(this.magnitude(i));
            printWriter.print('\t');
            printWriter.println(this.phase(i));
        }
    }
}

