/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Series
implements Iterable<Double> {
    public abstract int length();

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public abstract double x(int var1);

    public double minX() {
        int n = this.length();
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.min(d, this.x(i));
        }
        return d;
    }

    public double maxX() {
        int n = this.length();
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, this.x(i));
        }
        return d;
    }

    public Stats stats() {
        return new Stats(this);
    }

    public RobustStats robustStats() {
        return new RobustStats(this);
    }

    @Override
    public Iterator<Double> iterator() {
        return new Iterator<Double>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Series.this.length();
            }

            @Override
            public Double next() {
                try {
                    return Series.this.x(this.i++);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream printStream) {
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            printStream.print(i);
            printStream.print('\t');
            printStream.println(this.x(i));
        }
    }

    public void print(PrintWriter printWriter) {
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            printWriter.print(i);
            printWriter.print('\t');
            printWriter.println(this.x(i));
        }
    }

    public static class RobustStats {
        public final double median;
        public final double meanAbsDev;
        private double[] data;

        private RobustStats(Series series) {
            int n = series.length();
            this.data = new double[n];
            for (int i = 0; i < n; ++i) {
                this.data[i] = series.x(i);
            }
            Arrays.sort(this.data);
            if (n == 0) {
                this.median = Double.NaN;
                this.meanAbsDev = Double.NaN;
            } else {
                this.median = this.quantile(0.5);
                double d = 0.0;
                for (int i = 0; i < n; ++i) {
                    d += Math.abs(this.data[i] - this.median);
                }
                this.meanAbsDev = d / (double)n;
            }
        }

        public double quantile(double d) {
            if (0.0 > d || d > 1.0) {
                throw new IllegalArgumentException("Series.RobustStats.quantile(): q = " + d + " illegal");
            }
            return this.data.length == 0 ? Double.NaN : (d == 0.0 ? Double.NEGATIVE_INFINITY : this.data[(int)Math.ceil(d * (double)this.data.length) - 1]);
        }

        public int histogram(double d, double d2) {
            int n;
            int n2;
            if (d > d2) {
                throw new IllegalArgumentException("RobustStats.histogram(): lb (" + d + ") > ub (" + d2 + ") illegal");
            }
            int n3 = this.data.length;
            for (n2 = 0; n2 < n3 && this.data[n2] < d; ++n2) {
            }
            for (n = n2; n < n3 && this.data[n] < d2; ++n) {
            }
            return n - n2;
        }
    }

    public static class Stats {
        public final double mean;
        public final double var;
        public final double stddev;

        private Stats(Series series) {
            int n = series.length();
            if (n == 0) {
                this.mean = Double.NaN;
                this.var = Double.NaN;
                this.stddev = Double.NaN;
            } else {
                double d = 0.0;
                for (int i = 0; i < n; ++i) {
                    d += series.x(i);
                }
                this.mean = d / (double)n;
                double d2 = 0.0;
                double d3 = 0.0;
                for (int i = 0; i < n; ++i) {
                    double d4 = series.x(i) - this.mean;
                    d2 += d4;
                    d3 += d4 * d4;
                }
                this.var = n == 1 ? 0.0 : (d3 - d2 * d2 / (double)n) / (double)(n - 1);
                this.stddev = Math.sqrt(this.var);
            }
        }
    }
}

