/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.DoublePrng;
import edu.rit.util.Random;

public class NormalPrng
extends DoublePrng {
    private double myMean;
    private double myStdev;
    private double u1 = -1.0;
    private double u2;
    private static final double TWO_PI = Math.PI * 2;

    public NormalPrng(Random random) {
        this(random, 0.0, 1.0);
    }

    public NormalPrng(Random random, double d, double d2) {
        super(random);
        this.myMean = d;
        this.myStdev = d2;
    }

    public double next() {
        double d;
        if (this.u1 == -1.0) {
            double d2 = this.myUniformPrng.nextDouble();
            double d3 = this.myUniformPrng.nextDouble();
            this.u1 = Math.sqrt(-2.0 * Math.log(d2));
            this.u2 = Math.PI * 2 * d3;
            d = this.u1 * Math.cos(this.u2);
        } else {
            d = this.u1 * Math.sin(this.u2);
            this.u1 = -1.0;
        }
        return this.myMean + this.myStdev * d;
    }
}

