/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.ArraySeries;
import edu.rit.numeric.Series;
import edu.rit.numeric.XYZSeries;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ArrayXYZSeries
extends XYZSeries
implements Externalizable {
    private static final long serialVersionUID = 8763124349962266396L;
    private double[] xarray;
    private double[] yarray;
    private double[] zarray;

    public ArrayXYZSeries() {
    }

    public ArrayXYZSeries(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null) {
            throw new NullPointerException("ArrayXYZSeries(): xarray is null");
        }
        if (dArray2 == null) {
            throw new NullPointerException("ArrayXYZSeries(): yarray is null");
        }
        if (dArray3 == null) {
            throw new NullPointerException("ArrayXYZSeries(): zarray is null");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("ArrayXYZSeries(): xarray length (= " + dArray.length + ") != yarray length (= " + dArray2.length + "), illegal");
        }
        if (dArray.length != dArray3.length) {
            throw new IllegalArgumentException("ArrayXYZSeries(): xarray length (= " + dArray.length + ") != zarray length (= " + dArray3.length + "), illegal");
        }
        this.xarray = dArray;
        this.yarray = dArray2;
        this.zarray = dArray3;
    }

    public int length() {
        return this.xarray.length;
    }

    public double x(int n) {
        return this.xarray[n];
    }

    public double y(int n) {
        return this.yarray[n];
    }

    public double z(int n) {
        return this.zarray[n];
    }

    public Series xSeries() {
        return new ArraySeries(this.xarray);
    }

    public Series ySeries() {
        return new ArraySeries(this.yarray);
    }

    public Series zSeries() {
        return new ArraySeries(this.zarray);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.xarray.length;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeDouble(this.xarray[i]);
            objectOutput.writeDouble(this.yarray[i]);
            objectOutput.writeDouble(this.zarray[i]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        this.xarray = new double[n];
        this.yarray = new double[n];
        this.zarray = new double[n];
        for (int i = 0; i < n; ++i) {
            this.xarray[i] = objectInput.readDouble();
            this.yarray[i] = objectInput.readDouble();
            this.zarray[i] = objectInput.readDouble();
        }
    }
}

