/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri.test;

import edu.rit.mri.PixelSignal;
import edu.rit.mri.SignalDataSetReader;
import edu.rit.mri.SpinSignal;
import edu.rit.mri.SpinSignalDifference;
import edu.rit.numeric.AggregateXYSeries;
import edu.rit.numeric.ListXYSeries;
import edu.rit.numeric.NonLinearLeastSquares;
import edu.rit.numeric.NonNegativeLeastSquares;
import edu.rit.numeric.Series;
import edu.rit.numeric.TooManyIterationsException;
import edu.rit.numeric.VectorFunction;
import edu.rit.numeric.XYSeries;
import edu.rit.numeric.plot.Dots;
import edu.rit.numeric.plot.Plot;
import edu.rit.numeric.plot.Strokes;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Test05 {
    private Test05() {
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        int n;
        if (stringArray.length != 5) {
            Test05.usage();
        }
        File file = new File(stringArray[0]);
        double d = Double.parseDouble(stringArray[1]);
        double d2 = Double.parseDouble(stringArray[2]);
        int n2 = Integer.parseInt(stringArray[3]);
        int n3 = Integer.parseInt(stringArray[4]);
        SignalDataSetReader signalDataSetReader = new SignalDataSetReader(file);
        Series series = signalDataSetReader.getTimeSeries();
        int n4 = series.length();
        PixelSignal pixelSignal = signalDataSetReader.getPixelSignal(n3);
        if (pixelSignal == null) {
            System.err.println("Test05: Pixel " + n3 + " has no data");
            System.exit(0);
        }
        Series series2 = pixelSignal.S_measured();
        AggregateXYSeries aggregateXYSeries = new AggregateXYSeries(series, series2);
        double[] dArray = new double[n2 + 1];
        double d3 = Math.log(d);
        double d4 = Math.log(d2);
        double d5 = (d4 - d3) / (double)n2;
        for (int i = 0; i <= n2; ++i) {
            dArray[i] = Math.exp(d3 + (double)i * d5);
        }
        NonNegativeLeastSquares nonNegativeLeastSquares = new NonNegativeLeastSquares(n4, n2 + 1);
        for (int i = 0; i < n4; ++i) {
            double[] dArray2 = nonNegativeLeastSquares.a[i];
            double d6 = aggregateXYSeries.x(i);
            for (int j = 0; j <= n2; ++j) {
                dArray2[j] = SpinSignal.S(dArray[j], d6);
            }
            nonNegativeLeastSquares.b[i] = aggregateXYSeries.y(i);
        }
        nonNegativeLeastSquares.solve();
        double[] dArray3 = nonNegativeLeastSquares.x;
        System.out.println("Linear analysis: density, R1, T1");
        for (int i = 0; i <= n2; ++i) {
            if (!(dArray3[i] > 0.0)) continue;
            System.out.print(i);
            System.out.print(". ");
            System.out.print(dArray3[i]);
            System.out.print('\t');
            System.out.print(dArray[i]);
            System.out.print('\t');
            System.out.print(1.0 / dArray[i]);
            System.out.println();
        }
        System.out.print("chi^2 = ");
        System.out.print(nonNegativeLeastSquares.normsqr);
        System.out.println();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        ArrayList<Double> arrayList4 = new ArrayList<Double>();
        System.out.println("Peaks in linear analysis: density, R1, T1");
        for (n = 0; n <= n2; ++n) {
            double d7 = dArray3[n];
            double d8 = n == 0 ? 0.0 : dArray3[n - 1];
            if (!(d7 > d8)) continue;
            double d9 = dArray3[n];
            double d10 = n == n2 ? 0.0 : dArray3[n + 1];
            if (!(d9 > d10)) continue;
            System.out.print(n);
            System.out.print(". ");
            System.out.print(dArray3[n]);
            System.out.print('\t');
            System.out.print(dArray[n]);
            System.out.print('\t');
            System.out.print(1.0 / dArray[n]);
            System.out.println();
            arrayList.add(dArray3[n]);
            arrayList2.add(dArray[n]);
        }
        n = 0;
        int n5 = arrayList.size();
        while (n5 > 0 && n == 0) {
            int n6;
            System.out.println("Nonlinear analysis, before: density, R1, T1");
            Test05.printSolution(aggregateXYSeries, arrayList, arrayList2);
            object2 = new SpinSignalDifference(aggregateXYSeries, n5);
            object = new NonLinearLeastSquares((VectorFunction)object2);
            for (n6 = 0; n6 < n5; ++n6) {
                ((NonLinearLeastSquares)object).x[n6 << 1] = arrayList.get(n6);
                ((NonLinearLeastSquares)object).x[(n6 << 1) + 1] = arrayList2.get(n6);
            }
            try {
                ((NonLinearLeastSquares)object).solve();
                arrayList3.clear();
                arrayList4.clear();
                for (n6 = 0; n6 < n5; ++n6) {
                    arrayList3.add(((NonLinearLeastSquares)object).x[n6 << 1]);
                    arrayList4.add(((NonLinearLeastSquares)object).x[(n6 << 1) + 1]);
                }
                System.out.println("Nonlinear analysis, after: R1, T1");
                Test05.printSolution(aggregateXYSeries, arrayList3, arrayList4);
                n = Test05.checkPlausibility(aggregateXYSeries, arrayList3, arrayList4) ? 1 : 0;
            }
            catch (TooManyIterationsException tooManyIterationsException) {
                System.out.println("*** Too many iterations in nonlinear solver");
                n = 0;
            }
            if (n == 0) {
                double d11 = Double.MAX_VALUE;
                int n7 = 0;
                for (int i = 0; i < n5; ++i) {
                    if (!(arrayList.get(i) < d11)) continue;
                    d11 = arrayList.get(i);
                    n7 = i;
                }
                arrayList.remove(n7);
                arrayList2.remove(n7);
                n5 = arrayList.size();
                continue;
            }
            arrayList = arrayList3;
            arrayList2 = arrayList4;
        }
        object2 = new Plot();
        ((Plot)object2).xAxisLength(1200.0).xAxisMajorDivisions(20).yAxisLength(600.0).yAxisMajorDivisions(10).seriesDots(Dots.circle(Color.BLACK, null, null, 5.0)).seriesColor(Color.BLACK).seriesStroke(Strokes.solid(2.0)).xySeries(aggregateXYSeries);
        if (n5 > 0) {
            object = new ListXYSeries();
            for (int i = 0; i < n4; ++i) {
                double d12 = aggregateXYSeries.x(i);
                double d13 = 0.0;
                for (int j = 0; j < arrayList.size(); ++j) {
                    d13 += SpinSignal.S(arrayList.get(j), arrayList2.get(j), d12);
                }
                ((ListXYSeries)object).add(d12, d13);
            }
            ((Plot)object2).seriesDots(null).seriesColor(Color.RED).seriesStroke(Strokes.solid(1.0)).xySeries((XYSeries)object);
        } else {
            System.out.println("*** Could not find plausible solution");
        }
        ((Plot)object2).getFrame().setVisible(true);
    }

    private static void printSolution(XYSeries xYSeries, ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            System.out.print(arrayList.get(i));
            System.out.print('\t');
            System.out.print(arrayList2.get(i));
            System.out.print('\t');
            System.out.print(1.0 / arrayList2.get(i));
            System.out.println();
        }
        System.out.print("chi^2 = ");
        System.out.print(Test05.computeChiSqr(xYSeries, arrayList, arrayList2));
        System.out.println();
    }

    private static double computeChiSqr(XYSeries xYSeries, ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        int n = xYSeries.length();
        int n2 = arrayList.size();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = xYSeries.x(i);
            double d3 = 0.0;
            for (int j = 0; j < n2; ++j) {
                d3 += SpinSignal.S(arrayList.get(j), arrayList2.get(j), d2);
            }
            double d4 = d3 - xYSeries.y(i);
            d += d4 * d4;
        }
        return d;
    }

    private static boolean checkPlausibility(XYSeries xYSeries, ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        double d;
        int n;
        int n2 = xYSeries.length();
        int n3 = arrayList.size();
        for (n = 0; n < n3; ++n) {
            if (arrayList.get(n) < 0.0) {
                System.out.println("*** Negative density: " + arrayList.get(n));
                return false;
            }
            if (!(arrayList2.get(n) < 0.0)) continue;
            System.out.println("*** Negative rate: " + arrayList2.get(n));
            return false;
        }
        for (n = 0; n < n3 - 1; ++n) {
            double d2 = arrayList2.get(n);
            for (int i = n + 1; i < n3; ++i) {
                double d3 = arrayList2.get(i);
                double d4 = 2.0 * Math.abs(d2 - d3) / Math.abs(d2 + d3);
                if (!(d4 <= 0.001)) continue;
                System.out.println("*** Rates too close: " + d2 + " and " + d3 + ", reldiff = " + d4);
                return false;
            }
        }
        double d5 = 0.0;
        for (int i = 0; i < n3; ++i) {
            d5 += arrayList.get(i).doubleValue();
        }
        double d6 = 0.0;
        int n4 = 0;
        for (int i = n2 - 1; i >= 0 && n4 < 7; ++n4, --i) {
            d6 += xYSeries.y(i);
        }
        if ((d = Math.abs(d5 - (d6 /= (double)n4)) / Math.abs(d6)) >= 0.2) {
            System.out.println("*** Sum of densities = " + d5 + " doesn't agree with asymptotic measurement = " + d6 + ", reldiff = " + d);
            return false;
        }
        return true;
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.mri.test.Test05 <signalfile> <R1_lower> <R1_upper> <N> <index>");
        System.err.println("<signalfile> = Input spin signal data set file");
        System.err.println("<R1_lower> = Lower R1 spin-lattice relaxation rate (1/sec)");
        System.err.println("<R1_upper> = Upper R1 spin-lattice relaxation rate (1/sec)");
        System.err.println("<N> = Number of R1 intervals");
        System.err.println("<index> = Pixel index");
        System.exit(1);
    }
}

