/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.mri.PixelTissues;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TissuesDataSetReader {
    private RandomAccessFile myFile;
    private int H;
    private int W;
    private int P;

    public TissuesDataSetReader(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("TissuesDataSetReader(): theFile is null");
        }
        this.myFile = new RandomAccessFile(file, "r");
        this.H = this.myFile.readInt();
        this.W = this.myFile.readInt();
        this.P = this.H * this.W;
    }

    public int getHeight() {
        return this.H;
    }

    public int getWidth() {
        return this.W;
    }

    public int getPixelCount() {
        return this.P;
    }

    public int indexFor(int n, int n2) {
        if (0 > n || n >= this.H) {
            throw new IndexOutOfBoundsException("TissuesDataSetReader.indexFor(): r (= " + n + ") out of bounds");
        }
        if (0 > n2 || n2 >= this.W) {
            throw new IndexOutOfBoundsException("TissuesDataSetReader.indexFor(): c (= " + n2 + ") out of bounds");
        }
        return n * this.W + n2;
    }

    public int rowFor(int n) {
        if (0 > n || n >= this.P) {
            throw new IndexOutOfBoundsException("TissuesDataSetReader.rowFor(): i (= " + n + ") out of bounds");
        }
        return n / this.W;
    }

    public int columnFor(int n) {
        if (0 > n || n >= this.P) {
            throw new IndexOutOfBoundsException("TissuesDataSetReader.columnFor(): i (= " + n + ") out of bounds");
        }
        return n % this.W;
    }

    public PixelTissues getPixelTissues(int n) throws IOException {
        if (0 > n || n >= this.P) {
            throw new IndexOutOfBoundsException("TissuesDataSetReader.getPixelTissues(): i (= " + n + ") out of bounds");
        }
        this.myFile.seek(8L + (long)n * 8L);
        long l = this.myFile.readLong();
        if (l == 0L) {
            return null;
        }
        this.myFile.seek(l);
        PixelTissues pixelTissues = new PixelTissues();
        pixelTissues.pixelIndex(n);
        pixelTissues.read(this.myFile);
        return pixelTissues;
    }

    public void close() throws IOException {
        this.myFile.close();
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

