/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.mri.SpinSignal;
import edu.rit.numeric.ArraySeries;
import edu.rit.numeric.Series;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PixelTissues
implements Externalizable {
    private static final long serialVersionUID = 5354464511124925380L;
    private int fileIndex;
    private int pixelIndex;
    private double[] rho;
    private double[] R1;

    public PixelTissues() {
    }

    public PixelTissues(int n, int n2, List<Double> list, List<Double> list2) {
        this.fileIndex(n);
        this.pixelIndex(n2);
        this.tissues(list, list2);
    }

    public int fileIndex() {
        return this.fileIndex;
    }

    public void fileIndex(int n) {
        this.fileIndex = n;
    }

    public int pixelIndex() {
        return this.pixelIndex;
    }

    public void pixelIndex(int n) {
        this.pixelIndex = n;
    }

    public void tissues(List<Double> list, List<Double> list2) {
        int n;
        int n2 = list == null ? 0 : list.size();
        int n3 = n = list2 == null ? 0 : list2.size();
        if (n2 != n) {
            throw new IllegalArgumentException("PixelTissues.tissues(): rho_list length (= " + n2 + ") != R1_list length (= " + n + "), illegal");
        }
        if (list != null && list2 != null) {
            int n4 = list.size();
            this.rho = new double[n4];
            this.R1 = new double[n4];
            for (int i = 0; i < n4; ++i) {
                this.rho[i] = list.get(i);
                this.R1[i] = list2.get(i);
            }
        } else {
            this.rho = null;
            this.R1 = null;
        }
    }

    public int numTissues() {
        return this.rho == null ? 0 : this.rho.length;
    }

    public double rho(int n) {
        return this.rho[n];
    }

    public double R1(int n) {
        return this.R1[n];
    }

    public double S(double d) {
        if (this.rho == null) {
            return 0.0;
        }
        double d2 = 0.0;
        for (int i = 0; i < this.rho.length; ++i) {
            d2 += SpinSignal.S(this.rho[i], this.R1[i], d);
        }
        return d2;
    }

    public Series S_series(Series series) {
        if (this.rho == null) {
            return null;
        }
        int n = series.length();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = series.x(i);
            double d2 = 0.0;
            for (int j = 0; j < this.rho.length; ++j) {
                d2 += SpinSignal.S(this.rho[j], this.R1[j], d);
            }
            dArray[i] = d2;
        }
        return new ArraySeries(dArray);
    }

    public void write(DataOutput dataOutput) throws IOException {
        int n;
        int n2 = this.rho == null ? 0 : this.rho.length;
        dataOutput.writeShort((short)n2);
        for (n = 0; n < n2; ++n) {
            dataOutput.writeDouble(this.rho[n]);
        }
        for (n = 0; n < n2; ++n) {
            dataOutput.writeDouble(this.R1[n]);
        }
    }

    public void read(DataInput dataInput) throws IOException {
        int n = dataInput.readShort();
        if (n == 0) {
            this.rho = null;
            this.R1 = null;
        } else {
            int n2;
            this.rho = new double[n];
            this.R1 = new double[n];
            for (n2 = 0; n2 < n; ++n2) {
                this.rho[n2] = dataInput.readDouble();
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.R1[n2] = dataInput.readDouble();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.fileIndex);
        objectOutput.writeInt(this.pixelIndex);
        this.write(objectOutput);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.fileIndex = objectInput.readInt();
        this.pixelIndex = objectInput.readInt();
        this.read(objectInput);
    }
}

