/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.IntegerBuf;
import edu.rit.mp.buf.SharedIntegerArrayReductionBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedIntegerArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class SharedIntegerArrayBuf
extends IntegerBuf {
    SharedIntegerArray myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public SharedIntegerArrayBuf(SharedIntegerArray sharedIntegerArray, Range range) {
        super(range.length());
        this.myArray = sharedIntegerArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public int get(int n) {
        return this.myArray.get(this.myArrayOffset + n * this.myStride);
    }

    public void put(int n, int n2) {
        this.myArray.set(this.myArrayOffset + n * this.myStride, n2);
    }

    public Buf getReductionBuf(Op op) {
        return new SharedIntegerArrayReductionBuf(this.myArray, this.myRange, (IntegerOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = n;
        int n3 = this.myArrayOffset + n * this.myStride;
        while (n2 < this.myLength && byteBuffer.remaining() >= 4) {
            byteBuffer.putInt(this.myArray.get(n3));
            ++n2;
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 4) {
            this.myArray.set(n4, byteBuffer.getInt());
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

