/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.BooleanBuf;
import edu.rit.mp.Buf;
import edu.rit.mp.buf.SharedBooleanArrayReductionBuf;
import edu.rit.pj.reduction.BooleanOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedBooleanArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class SharedBooleanArrayBuf
extends BooleanBuf {
    SharedBooleanArray myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public SharedBooleanArrayBuf(SharedBooleanArray sharedBooleanArray, Range range) {
        super(range.length());
        this.myArray = sharedBooleanArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public boolean get(int n) {
        return this.myArray.get(this.myArrayOffset + n * this.myStride);
    }

    public void put(int n, boolean bl) {
        this.myArray.set(this.myArrayOffset + n * this.myStride, bl);
    }

    public Buf getReductionBuf(Op op) {
        return new SharedBooleanArrayReductionBuf(this.myArray, this.myRange, (BooleanOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = n;
        int n3 = this.myArrayOffset + n * this.myStride;
        while (n2 < this.myLength && byteBuffer.remaining() >= 1) {
            byteBuffer.put(this.myArray.get(n3) ? (byte)1 : 0);
            ++n2;
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 1) {
            this.myArray.set(n4, byteBuffer.get() != 0);
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

