/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectMatrixBuf;
import edu.rit.pj.reduction.ObjectOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ObjectMatrixReductionBuf<T>
extends ObjectMatrixBuf<T> {
    ObjectOp<T> myOp;
    ObjectMatrixBuf<T> myBuf;

    public ObjectMatrixReductionBuf(T[][] TArray, Range range, Range range2, ObjectOp<T> objectOp, ObjectMatrixBuf<T> objectMatrixBuf) {
        super(TArray, range, range2);
        if (objectOp == null) {
            throw new NullPointerException("ObjectMatrixReductionBuf(): op is null");
        }
        this.myOp = objectOp;
        this.myBuf = objectMatrixBuf;
    }

    @Override
    public void put(int n, T t) {
        int n2 = this.i2r(n) * this.myRowStride + this.myLowerRow;
        int n3 = this.i2c(n) * this.myColStride + this.myLowerCol;
        this.myMatrix[n2][n3] = this.myOp.op(this.myMatrix[n2][n3], t);
        this.reset();
        this.myBuf.reset();
    }

    @Override
    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof ObjectMatrixBuf) {
                ObjectMatrixBuf objectMatrixBuf = (ObjectMatrixBuf)buf;
                ReduceArrays.reduce(objectMatrixBuf.myMatrix, objectMatrixBuf.myRowRange, objectMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
                this.reset();
                this.myBuf.reset();
            } else {
                ObjectBuf.defaultCopy((ObjectBuf)buf, this);
                this.reset();
                this.myBuf.reset();
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }
}

