/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.LongArrayReductionBuf;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class LongArrayBuf
extends LongBuf {
    long[] myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public LongArrayBuf(long[] lArray, Range range) {
        super(range.length());
        this.myArray = lArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public long get(int n) {
        return this.myArray[this.myArrayOffset + n * this.myStride];
    }

    public void put(int n, long l) {
        this.myArray[this.myArrayOffset + n * this.myStride] = l;
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof LongArrayBuf) {
                LongArrayBuf longArrayBuf = (LongArrayBuf)buf;
                Arrays.copy(longArrayBuf.myArray, longArrayBuf.myRange, this.myArray, this.myRange);
            } else {
                LongBuf.defaultCopy((LongBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        return new LongArrayReductionBuf(this.myArray, this.myRange, (LongOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = n;
        int n3 = this.myArrayOffset + n * this.myStride;
        while (n2 < this.myLength && byteBuffer.remaining() >= 8) {
            byteBuffer.putLong(this.myArray[n3]);
            ++n2;
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 8) {
            this.myArray[n4] = byteBuffer.getLong();
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

