/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.io;

import edu.rit.io.InvalidMatrixFileException;
import edu.rit.util.Range;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DoubleMatrixFile {
    private static final long BYTES_PER_ELEMENT = 8L;
    private int R = -1;
    private int C = -1;
    private double[][] myMatrix;

    public DoubleMatrixFile() {
    }

    public DoubleMatrixFile(int n, int n2, double[][] dArray) {
        this.setMatrix(n, n2, dArray);
    }

    public int getRowCount() {
        return this.R;
    }

    public int getColCount() {
        return this.C;
    }

    public double[][] getMatrix() {
        return this.myMatrix;
    }

    public void setMatrix(int n, int n2, double[][] dArray) {
        this.setRC(n, n2);
        if (dArray.length != n) {
            throw new IllegalArgumentException("DoubleMatrixFile.setMatrix(): theMatrix.length (= " + dArray.length + ") does not equal R (= " + n + ")");
        }
        this.myMatrix = dArray;
    }

    public Writer prepareToWrite(OutputStream outputStream) throws IOException {
        if (this.myMatrix == null) {
            throw new IllegalStateException("DoubleMatrixFile.prepareToWrite(): Not initialized");
        }
        return new Writer(outputStream);
    }

    public Reader prepareToRead(InputStream inputStream) throws IOException {
        return new Reader(inputStream);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: java edu.rit.io.DoubleMatrixFile <outfile> <infile1> [<infile2> ...]");
            System.exit(1);
        }
        DoubleMatrixFile doubleMatrixFile = new DoubleMatrixFile();
        for (int i = 1; i < stringArray.length; ++i) {
            Reader reader = doubleMatrixFile.prepareToRead(new BufferedInputStream(new FileInputStream(stringArray[i])));
            reader.read();
            reader.close();
        }
        Writer writer = doubleMatrixFile.prepareToWrite(new BufferedOutputStream(new FileOutputStream(stringArray[0])));
        writer.write();
        writer.close();
    }

    void setRC(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("DoubleMatrixFile.setHeightAndWidth(): R = " + n + " illegal");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("DoubleMatrixFile.setHeightAndWidth(): C = " + n2 + " illegal");
        }
        this.R = n;
        this.C = n2;
    }

    static /* synthetic */ double[][] access$402(DoubleMatrixFile doubleMatrixFile, double[][] dArray) {
        doubleMatrixFile.myMatrix = dArray;
        return dArray;
    }

    public class Reader {
        private InputStream myIs;
        private DataInputStream myDis;
        private Range myRowRange;
        private Range myColRange;

        private Reader(InputStream inputStream) throws IOException {
            if (inputStream == null) {
                throw new NullPointerException("DoubleMatrixFile.Reader(): theStream is null");
            }
            this.myIs = inputStream;
            this.myDis = new DataInputStream(inputStream);
            int n = this.myDis.readInt();
            int n2 = this.myDis.readInt();
            if (DoubleMatrixFile.this.myMatrix == null) {
                DoubleMatrixFile.this.setRC(n, n2);
                DoubleMatrixFile.access$402(DoubleMatrixFile.this, new double[n][]);
            } else {
                if (DoubleMatrixFile.this.R != n) {
                    throw new InvalidMatrixFileException("DoubleMatrixFile.Reader(): Number of rows from stream (" + n + ") != number of rows in this matrix file (" + DoubleMatrixFile.this.R + ")");
                }
                if (DoubleMatrixFile.this.C != n2) {
                    throw new InvalidMatrixFileException("DoubleMatrixFile.Reader(): Number of columns from stream (" + n2 + ") != number of columns in this matrix file (" + DoubleMatrixFile.this.C + ")");
                }
            }
            this.getNextSegment();
        }

        public void read() throws IOException {
            while (this.myRowRange != null) {
                this.readSegment();
            }
        }

        public void readRowSlice(Range range) throws IOException {
            while (this.myRowRange != null) {
                this.readSegmentRowSlice(range);
            }
        }

        public void readColSlice(Range range) throws IOException {
            while (this.myRowRange != null) {
                this.readSegmentColSlice(range);
            }
        }

        public void readPatch(Range range, Range range2) throws IOException {
            while (this.myRowRange != null) {
                this.readSegmentPatch(range, range2);
            }
        }

        public Range getRowRange() {
            return this.myRowRange;
        }

        public Range getColRange() {
            return this.myColRange;
        }

        public void readSegment() throws IOException {
            this.readSegment(0, DoubleMatrixFile.this.R - 1, 0, DoubleMatrixFile.this.C - 1);
        }

        public void readSegmentRowSlice(Range range) throws IOException {
            if (range.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Reader.readSegmentRowSlice(): theRowRange stride > 1");
            }
            int n = range.lb();
            int n2 = range.ub();
            if (0 > n || n + range.length() > DoubleMatrixFile.this.R) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Reader.readSegmentRowSlice(): theRowRange = " + range + " out of bounds");
            }
            this.readSegment(n, n2, 0, DoubleMatrixFile.this.C - 1);
        }

        public void readSegmentColSlice(Range range) throws IOException {
            if (range.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Reader.readSegmentColSlice(): theColRange stride > 1");
            }
            int n = range.lb();
            int n2 = range.ub();
            if (0 > n || n + range.length() > DoubleMatrixFile.this.C) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Reader.readSegmentColSlice(): theColRange = " + range + " out of bounds");
            }
            this.readSegment(0, DoubleMatrixFile.this.R - 1, n, n2);
        }

        public void readSegmentPatch(Range range, Range range2) throws IOException {
            if (range.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Reader.readSegmentPatch(): theRowRange stride > 1");
            }
            int n = range.lb();
            int n2 = range.ub();
            if (0 > n || n + range.length() > DoubleMatrixFile.this.R) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Reader.readSegmentPatch(): theRowRange = " + range + " out of bounds");
            }
            if (range2.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Reader.readSegmentPatch(): theColRange stride > 1");
            }
            int n3 = range2.lb();
            int n4 = range2.ub();
            if (0 > n3 || n3 + range2.length() > DoubleMatrixFile.this.C) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Reader.readSegmentPatch(): theColRange = " + range2 + " out of bounds");
            }
            this.readSegment(n, n2, n3, n4);
        }

        public void close() throws IOException {
            this.myDis.close();
        }

        private void getNextSegment() throws IOException {
            try {
                int n = this.myDis.readInt();
                int n2 = this.myDis.readInt();
                int n3 = this.myDis.readInt();
                int n4 = this.myDis.readInt();
                if (n < 0) {
                    throw new InvalidMatrixFileException("DoubleMatrixFile.Reader.getNextSegment(): Invalid segment lower row index (" + n + ")");
                }
                if (n2 < 0) {
                    throw new InvalidMatrixFileException("DoubleMatrixFile.Reader.getNextSegment(): Invalid segment lower column index (" + n2 + ")");
                }
                if (n3 < 0 || n + n3 > DoubleMatrixFile.this.R) {
                    throw new InvalidMatrixFileException("DoubleMatrixFile.Reader.getNextSegment(): Invalid numer of rows in segment (" + n3 + ")");
                }
                if (n4 < 0 || n2 + n4 > DoubleMatrixFile.this.C) {
                    throw new InvalidMatrixFileException("DoubleMatrixFile.Reader.getNextSegment(): Invalid numer of columns in segment (" + n4 + ")");
                }
                this.myRowRange = new Range(n, n + n3 - 1);
                this.myColRange = new Range(n2, n2 + n4 - 1);
            }
            catch (EOFException eOFException) {
                this.myRowRange = null;
                this.myColRange = null;
            }
        }

        private void readSegment(int n, int n2, int n3, int n4) throws IOException {
            if (this.myRowRange == null) {
                return;
            }
            int n5 = this.myRowRange.lb();
            int n6 = this.myRowRange.ub();
            int n7 = this.myColRange.lb();
            int n8 = this.myColRange.ub();
            long l = 8L * (long)this.myColRange.length();
            int n9 = Math.max(n, n5);
            int n10 = Math.min(n2, n6);
            int n11 = n9 - n5;
            long l2 = (long)n11 * l;
            int n12 = n6 - n10;
            long l3 = (long)n12 * l;
            int n13 = Math.max(n3, n7);
            int n14 = Math.min(n4, n8);
            int n15 = n13 - n7;
            long l4 = (long)n15 * 8L;
            int n16 = n8 - n14;
            long l5 = (long)n16 * 8L;
            this.skipFully(l2);
            for (int i = n9; i <= n10; ++i) {
                double[] dArray = DoubleMatrixFile.this.myMatrix[i];
                if (dArray == null) {
                    dArray = new double[DoubleMatrixFile.this.C];
                    ((DoubleMatrixFile)DoubleMatrixFile.this).myMatrix[i] = dArray;
                }
                this.skipFully(l4);
                for (int j = n13; j <= n14; ++j) {
                    dArray[j] = this.myDis.readDouble();
                }
                this.skipFully(l5);
            }
            this.skipFully(l3);
            this.getNextSegment();
        }

        private void skipFully(long l) throws IOException {
            while (l > 0L) {
                l -= this.myDis.skip(l);
            }
        }
    }

    public class Writer {
        private OutputStream myOs;
        private DataOutputStream myDos;

        private Writer(OutputStream outputStream) throws IOException {
            if (outputStream == null) {
                throw new NullPointerException("DoubleMatrixFile.Writer(): theStream is null");
            }
            this.myOs = outputStream;
            this.myDos = new DataOutputStream(outputStream);
            this.myDos.writeInt(DoubleMatrixFile.this.R);
            this.myDos.writeInt(DoubleMatrixFile.this.C);
        }

        public void write() throws IOException {
            this.write(0, DoubleMatrixFile.this.R - 1, 0, DoubleMatrixFile.this.C - 1);
        }

        public void writeRowSlice(Range range) throws IOException {
            if (range.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Writer.writeRowSlice(): theRowRange stride > 1");
            }
            int n = range.lb();
            int n2 = range.ub();
            if (0 > n || n + range.length() > DoubleMatrixFile.this.R) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Writer.writeRowSlice(): theRowRange = " + range + " out of bounds");
            }
            this.write(n, n2, 0, DoubleMatrixFile.this.C - 1);
        }

        public void writeColSlice(Range range) throws IOException {
            if (range.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Writer.writeColSlice(): theColRange stride > 1");
            }
            int n = range.lb();
            int n2 = range.ub();
            if (0 > n || n + range.length() > DoubleMatrixFile.this.C) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Writer.writeColSlice(): theColRange = " + range + " out of bounds");
            }
            this.write(0, DoubleMatrixFile.this.R - 1, n, n2);
        }

        public void writePatch(Range range, Range range2) throws IOException {
            if (range.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Writer.writePatch(): theRowRange stride > 1");
            }
            if (range2.stride() != 1) {
                throw new IllegalArgumentException("DoubleMatrixImage.Writer.writePatch(): theColRange stride > 1");
            }
            int n = range.lb();
            int n2 = range.ub();
            if (0 > n || n + range.length() > DoubleMatrixFile.this.R) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Writer.writePatch(): theRowRange = " + range + " out of bounds");
            }
            int n3 = range2.lb();
            int n4 = range2.ub();
            if (0 > n3 || n3 + range2.length() > DoubleMatrixFile.this.C) {
                throw new IndexOutOfBoundsException("DoubleMatrixImage.Writer.writePatch(): theColRange = " + range2 + " out of bounds");
            }
            this.write(n, n2, n3, n4);
        }

        public void close() throws IOException {
            this.myDos.close();
        }

        private void write(int n, int n2, int n3, int n4) throws IOException {
            this.myDos.writeInt(n);
            this.myDos.writeInt(n3);
            this.myDos.writeInt(n2 - n + 1);
            this.myDos.writeInt(n4 - n3 + 1);
            for (int i = n; i <= n2; ++i) {
                double[] dArray = DoubleMatrixFile.this.myMatrix[i];
                for (int j = n3; j <= n4; ++j) {
                    this.myDos.writeDouble(dArray[j]);
                }
            }
        }
    }
}

