/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image.test;

import edu.rit.image.PJGGrayImage;
import edu.rit.image.PJGImage;
import edu.rit.util.Hex;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class Test03 {
    static int width;
    static File filename;
    static byte[][] matrix;
    static PJGGrayImage image;
    static byte[][] matrix2;
    static PJGGrayImage image2;

    private Test03() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            Test03.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        filename = new File(stringArray[1]);
        matrix = new byte[width][width];
        image = new PJGGrayImage(width, width, matrix);
        image.setInterpretation(PJGGrayImage.ZERO_IS_BLACK);
        for (int i = 0; i < width; ++i) {
            double d = (double)i / (double)width * 4.0 - 2.0;
            for (int j = 0; j < width; ++j) {
                double d2 = (double)j / (double)width * 4.0 - 2.0;
                double d3 = Math.exp(-d2 * d2 - d * d);
                image.setPixel(i, j, (float)d3);
            }
        }
        PJGImage.Writer writer = image.prepareToWrite(new BufferedOutputStream(new FileOutputStream(filename)));
        writer.write();
        writer.close();
        image2 = new PJGGrayImage();
        PJGImage.Reader reader = image2.prepareToRead(new BufferedInputStream(new FileInputStream(filename)));
        reader.read();
        reader.close();
        matrix2 = image2.getMatrix();
        for (int i = 0; i < width; ++i) {
            byte[] byArray = matrix[i];
            byte[] byArray2 = matrix2[i];
            for (int j = 0; j < width; ++j) {
                if (byArray[j] == byArray2[j]) continue;
                System.out.print("matrix[");
                System.out.print(i);
                System.out.print("][");
                System.out.print(j);
                System.out.print("] = ");
                System.out.print(Hex.toString(byArray[j]));
                System.out.print(", matrix2[");
                System.out.print(i);
                System.out.print("][");
                System.out.print(j);
                System.out.print("] = ");
                System.out.print(Hex.toString(byArray2[j]));
                System.out.println();
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.image.test.Test03 <width> <filename>");
        System.err.println("<width> = Image height and width (pixels)");
        System.err.println("<filename> = PJG image file name");
        System.exit(1);
    }
}

