/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.image.DataBufferByteMatrix;
import edu.rit.image.SampleModelByteMatrix;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

class ByteGrayColorModel
extends ColorModel {
    public ByteGrayColorModel() {
        super(8, new int[]{8}, ColorSpace.getInstance(1003), false, false, 1, 0);
    }

    public int getRed(int n) {
        return n & 0xFF;
    }

    public int getGreen(int n) {
        return n & 0xFF;
    }

    public int getBlue(int n) {
        return n & 0xFF;
    }

    public int getAlpha(int n) {
        return 255;
    }

    public int getRGB(int n) {
        int n2 = n & 0xFF;
        return 0xFF000000 | n2 << 16 | n2 << 8 | n2;
    }

    public boolean isCompatibleRaster(Raster raster) {
        return raster.getSampleModel() instanceof SampleModelByteMatrix && raster.getDataBuffer() instanceof DataBufferByteMatrix;
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        byte[][] byArray = new byte[n2][n];
        return Raster.createWritableRaster(new SampleModelByteMatrix(n, n2), new DataBufferByteMatrix(byArray), null);
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new SampleModelByteMatrix(n, n2);
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return sampleModel instanceof SampleModelByteMatrix;
    }
}

