/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.seq.test;

import edu.rit.compbio.seq.Alignment;
import edu.rit.compbio.seq.AlignmentPrinter;
import edu.rit.compbio.seq.DefaultAlignmentStats;
import edu.rit.compbio.seq.ProteinLocalAlignment;
import edu.rit.compbio.seq.ProteinLocalAlignmentSeq;
import edu.rit.compbio.seq.ProteinSequence;
import java.io.File;

public class TestSeq {
    private TestSeq() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            TestSeq.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        ProteinSequence proteinSequence = new ProteinSequence(file);
        ProteinSequence proteinSequence2 = new ProteinSequence(file2);
        DefaultAlignmentStats defaultAlignmentStats = new DefaultAlignmentStats(proteinSequence2.length());
        ProteinLocalAlignmentSeq proteinLocalAlignmentSeq = new ProteinLocalAlignmentSeq();
        proteinLocalAlignmentSeq.setQuerySequence(proteinSequence, 0L);
        proteinLocalAlignmentSeq.setSubjectSequence(proteinSequence2, 0L);
        Alignment alignment = ((ProteinLocalAlignment)proteinLocalAlignmentSeq).align();
        AlignmentPrinter alignmentPrinter = new AlignmentPrinter(System.out, defaultAlignmentStats);
        System.out.println();
        System.out.println("Query Description:");
        System.out.println(proteinSequence.description());
        System.out.println("Length = " + proteinSequence.length());
        System.out.println();
        alignmentPrinter.printDetails(alignment, proteinSequence, proteinSequence2);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.compbio.seq.test.TestSeq <queryfile> <subjectfile>");
        System.err.println("<queryfile> = Query sequence file");
        System.err.println("<subjectfile> = Subject sequence file");
        System.exit(1);
    }
}

