/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.seq;

import edu.rit.compbio.seq.Alignment;
import edu.rit.compbio.seq.AlignmentStats;
import edu.rit.compbio.seq.Blosum62;
import edu.rit.compbio.seq.Sequence;
import java.io.PrintStream;
import java.util.Formatter;

public class AlignmentPrinter {
    private PrintStream out;
    private AlignmentStats stats;
    private int[][] delta = Blosum62.matrix;

    public AlignmentPrinter(PrintStream printStream, AlignmentStats alignmentStats) {
        this.out = printStream;
        this.stats = alignmentStats;
    }

    public void setSubstitutionMatrix(int[][] nArray) {
        this.delta = nArray;
    }

    public void printSummary(Alignment alignment, Sequence sequence) {
        String string = sequence.description();
        if (string.length() > 60) {
            string = string.substring(0, 57) + "...";
        }
        double d = this.stats.bitScore(alignment);
        double d2 = this.stats.eValue(alignment);
        this.out.format("%-60s  %5s  %s%n", string, AlignmentPrinter.formatBitScore(d), AlignmentPrinter.formatEValue(d2));
    }

    public void printDetails(Alignment alignment, Sequence sequence, Sequence sequence2) {
        int n;
        int n2;
        int n3;
        this.out.println(sequence2.description());
        this.out.format("Length = %d%n", sequence2.length());
        this.out.println();
        double d = this.stats.bitScore(alignment);
        double d2 = this.stats.rawScore(alignment);
        double d3 = this.stats.eValue(alignment);
        this.out.format("Score = %s bits (%.0f), Expect = %s%n", AlignmentPrinter.formatBitScore(d), d2, AlignmentPrinter.formatEValue(d3));
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = alignment.myQueryStart;
        int n8 = alignment.mySubjectStart;
        int n9 = alignment.myTraceback.length;
        block19: for (n3 = 0; n3 < n9; ++n3) {
            switch (alignment.myTraceback[n9 - 1 - n3]) {
                case 0: {
                    n2 = sequence.mySequence[n7];
                    n = sequence2.mySequence[n8];
                    if (n2 == n) {
                        ++n4;
                        ++n5;
                    } else if (this.delta[n2][n] > 0) {
                        ++n5;
                    }
                    ++n7;
                    ++n8;
                    continue block19;
                }
                case 1: {
                    ++n6;
                    ++n7;
                    continue block19;
                }
                case 2: {
                    ++n6;
                    ++n8;
                }
            }
        }
        this.out.format("Identities = %d/%d (%.0f%%), ", n4, n9, (double)n4 / (double)n9 * 100.0);
        this.out.format("Positives = %d/%d (%.0f%%), ", n5, n9, (double)n5 / (double)n9 * 100.0);
        this.out.format("Gaps = %d/%d (%.0f%%)%n", n6, n9, (double)n6 / (double)n9 * 100.0);
        this.out.println();
        n7 = alignment.myQueryStart;
        n8 = alignment.mySubjectStart;
        for (n3 = 0; n3 < n9; n3 += n2) {
            n = n7;
            this.out.format("Query%6d  ", n);
            block21: for (n2 = 0; n2 < 60 && n3 + n2 < n9; ++n2) {
                switch (alignment.myTraceback[n9 - 1 - n3 - n2]) {
                    case 0: 
                    case 1: {
                        this.out.print(sequence.charAt(n));
                        ++n;
                        continue block21;
                    }
                    case 2: {
                        this.out.print('-');
                    }
                }
            }
            this.out.format("%6d%n", n - 1);
            n = n7;
            int n10 = n8;
            this.out.print("             ");
            block22: for (n2 = 0; n2 < 60 && n3 + n2 < n9; ++n2) {
                switch (alignment.myTraceback[n9 - 1 - n3 - n2]) {
                    case 0: {
                        byte by = sequence.mySequence[n];
                        byte by2 = sequence2.mySequence[n10];
                        if (by == by2) {
                            this.out.print(sequence.charAt(n));
                        } else if (this.delta[by][by2] > 0) {
                            this.out.print('+');
                        } else {
                            this.out.print(' ');
                        }
                        ++n;
                        ++n10;
                        continue block22;
                    }
                    case 1: {
                        this.out.print(' ');
                        ++n;
                        continue block22;
                    }
                    case 2: {
                        this.out.print(' ');
                        ++n10;
                    }
                }
            }
            this.out.println();
            n = n7;
            n10 = n8;
            this.out.format("Sbjct%6d  ", n10);
            block23: for (n2 = 0; n2 < 60 && n3 + n2 < n9; ++n2) {
                switch (alignment.myTraceback[n9 - 1 - n3 - n2]) {
                    case 0: {
                        this.out.print(sequence2.charAt(n10));
                        ++n;
                        ++n10;
                        continue block23;
                    }
                    case 1: {
                        this.out.print('-');
                        ++n;
                        continue block23;
                    }
                    case 2: {
                        this.out.print(sequence2.charAt(n10));
                        ++n10;
                    }
                }
            }
            this.out.format("%6d%n", n10 - 1);
            this.out.println();
            n7 = n;
            n8 = n10;
        }
    }

    private static String formatBitScore(double d) {
        Formatter formatter = new Formatter();
        if (d >= 100.0) {
            formatter.format("%.0f", d);
        } else if (d >= 10.0) {
            formatter.format("%.1f", d);
        } else {
            formatter.format("%.2f", d);
        }
        return formatter.toString();
    }

    private static String formatEValue(double d) {
        Formatter formatter = new Formatter();
        if (d < 1.0E-199) {
            formatter.format("0.0", new Object[0]);
        } else if (d < 0.001) {
            formatter.format("%.0e", d);
        } else if (d < 0.1) {
            formatter.format("%.3f", d);
        } else if (d < 1.0) {
            formatter.format("%.2f", d);
        } else if (d < 10.0) {
            formatter.format("%.1f", d);
        } else {
            formatter.format("%.0f", d);
        }
        return formatter.toString();
    }
}

