/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.seq;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alignment
implements Externalizable,
Comparable<Alignment> {
    public static final int QUERY_ALIGNED_WITH_SUBJECT = 0;
    public static final int QUERY_ALIGNED_WITH_GAP = 1;
    public static final int SUBJECT_ALIGNED_WITH_GAP = 2;
    private static final long serialVersionUID = 8656834485638780975L;
    long myQueryId;
    long mySubjectId;
    int myQueryLength;
    int mySubjectLength;
    int myScore;
    int myQueryStart;
    int mySubjectStart;
    int myQueryFinish;
    int mySubjectFinish;
    byte[] myTraceback;

    public long getQueryId() {
        return this.myQueryId;
    }

    public long getSubjectId() {
        return this.mySubjectId;
    }

    public int getQueryLength() {
        return this.myQueryLength;
    }

    public int getSubjectLength() {
        return this.mySubjectLength;
    }

    public int getQueryStart() {
        return this.myQueryStart;
    }

    public int getQueryFinish() {
        return this.myQueryFinish;
    }

    public int getSubjectStart() {
        return this.mySubjectStart;
    }

    public int getSubjectFinish() {
        return this.mySubjectFinish;
    }

    public int getAlignmentLength() {
        return this.myTraceback.length;
    }

    public int getAlignment(int n) {
        return this.myTraceback[this.myTraceback.length - 1 - n];
    }

    @Override
    public int compareTo(Alignment alignment) {
        if (this.myScore > alignment.myScore) {
            return -1;
        }
        if (this.myScore < alignment.myScore) {
            return 1;
        }
        if (this.mySubjectId < alignment.mySubjectId) {
            return -1;
        }
        if (this.mySubjectId > alignment.mySubjectId) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Alignment(qid=");
        stringBuilder.append(this.myQueryId);
        stringBuilder.append(",sid=");
        stringBuilder.append(this.mySubjectId);
        stringBuilder.append(",qlen=");
        stringBuilder.append(this.myQueryLength);
        stringBuilder.append(",slen=");
        stringBuilder.append(this.mySubjectLength);
        stringBuilder.append(",score=");
        stringBuilder.append(this.myScore);
        stringBuilder.append(",qstart=");
        stringBuilder.append(this.myQueryStart);
        stringBuilder.append(",sstart=");
        stringBuilder.append(this.mySubjectStart);
        stringBuilder.append(",qfin=");
        stringBuilder.append(this.myQueryFinish);
        stringBuilder.append(",sfin=");
        stringBuilder.append(this.mySubjectFinish);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.myQueryId);
        objectOutput.writeLong(this.mySubjectId);
        objectOutput.writeInt(this.myQueryLength);
        objectOutput.writeInt(this.mySubjectLength);
        objectOutput.writeInt(this.myScore);
        objectOutput.writeInt(this.myQueryStart);
        objectOutput.writeInt(this.mySubjectStart);
        objectOutput.writeInt(this.myQueryFinish);
        objectOutput.writeInt(this.mySubjectFinish);
        int n = this.myTraceback.length;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeByte(this.myTraceback[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.myQueryId = objectInput.readLong();
        this.mySubjectId = objectInput.readLong();
        this.myQueryLength = objectInput.readInt();
        this.mySubjectLength = objectInput.readInt();
        this.myScore = objectInput.readInt();
        this.myQueryStart = objectInput.readInt();
        this.mySubjectStart = objectInput.readInt();
        this.myQueryFinish = objectInput.readInt();
        this.mySubjectFinish = objectInput.readInt();
        int n = objectInput.readInt();
        this.myTraceback = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.myTraceback[i] = objectInput.readByte();
        }
    }
}

