/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.monte;

import edu.rit.pj.Comm;
import edu.rit.util.Random;

public class PiSeq {
    static long seed;
    static long N;
    static Random prng;
    static long count;

    private PiSeq() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = -System.currentTimeMillis();
        Comm.init(stringArray);
        if (stringArray.length != 2) {
            PiSeq.usage();
        }
        seed = Long.parseLong(stringArray[0]);
        N = Long.parseLong(stringArray[1]);
        prng = Random.getInstance(seed);
        count = 0L;
        for (long i = 0L; i < N; ++i) {
            double d;
            double d2 = prng.nextDouble();
            if (!(d2 * d2 + (d = prng.nextDouble()) * d <= 1.0)) continue;
            ++count;
        }
        System.out.println((l += System.currentTimeMillis()) + " msec total");
        System.out.println("pi = 4 * " + count + " / " + N + " = " + 4.0 * (double)count / (double)N);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.clu.monte.PiSeq <seed> <N>");
        System.err.println("<seed> = Random seed");
        System.err.println("<N> = Number of random points");
        System.exit(1);
    }
}

